/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.report;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.common.lib.report.UserReportletConf;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.ReportletConfClass;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.URelationship;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.utils.FormatUtils;
import org.apache.syncope.core.provisioning.java.job.report.AbstractReportlet;
import org.apache.syncope.core.provisioning.java.job.report.ReportException;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@ReportletConfClass(value=UserReportletConf.class)
public class UserReportlet
extends AbstractReportlet {
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private UserDataBinder userDataBinder;
    @Autowired
    private GroupDataBinder groupDataBinder;
    @Autowired
    private AnyObjectDataBinder anyObjectDataBinder;
    @Autowired
    private SearchCondVisitor searchCondVisitor;
    private UserReportletConf conf;

    private void doExtractResources(ContentHandler handler, AnyTO anyTO) throws SAXException {
        if (anyTO.getResources().isEmpty()) {
            LOG.debug("No resources found for {}[{}]", (Object)anyTO.getClass().getSimpleName(), (Object)anyTO.getKey());
        } else {
            AttributesImpl atts = new AttributesImpl();
            handler.startElement("", "", "resources", null);
            for (String resourceName : anyTO.getResources()) {
                atts.clear();
                atts.addAttribute("", "", "name", "xsd:string", resourceName);
                handler.startElement("", "", "resource", atts);
                handler.endElement("", "", "resource");
            }
            handler.endElement("", "", "resources");
        }
    }

    private void doExtractAttributes(ContentHandler handler, AnyTO anyTO, Collection<String> attrs, Collection<String> derAttrs, Collection<String> virAttrs) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (!attrs.isEmpty()) {
            Map attrMap = EntityTOUtils.buildAttrMap((Collection)anyTO.getPlainAttrs());
            handler.startElement("", "", "attributes", null);
            for (String attrName : attrs) {
                atts.clear();
                atts.addAttribute("", "", "name", "xsd:string", attrName);
                handler.startElement("", "", "attribute", atts);
                if (attrMap.containsKey(attrName)) {
                    for (String value : ((AttrTO)attrMap.get(attrName)).getValues()) {
                        handler.startElement("", "", "value", null);
                        handler.characters(value.toCharArray(), 0, value.length());
                        handler.endElement("", "", "value");
                    }
                } else {
                    LOG.debug("{} not found for {}[{}]", new Object[]{attrName, anyTO.getClass().getSimpleName(), anyTO.getKey()});
                }
                handler.endElement("", "", "attribute");
            }
            handler.endElement("", "", "attributes");
        }
        if (!derAttrs.isEmpty()) {
            Map derAttrMap = EntityTOUtils.buildAttrMap((Collection)anyTO.getDerAttrs());
            handler.startElement("", "", "derivedAttributes", null);
            for (String attrName : derAttrs) {
                atts.clear();
                atts.addAttribute("", "", "name", "xsd:string", attrName);
                handler.startElement("", "", "derivedAttribute", atts);
                if (derAttrMap.containsKey(attrName)) {
                    for (String value : ((AttrTO)derAttrMap.get(attrName)).getValues()) {
                        handler.startElement("", "", "value", null);
                        handler.characters(value.toCharArray(), 0, value.length());
                        handler.endElement("", "", "value");
                    }
                } else {
                    LOG.debug("{} not found for {}[{}]", new Object[]{attrName, anyTO.getClass().getSimpleName(), anyTO.getKey()});
                }
                handler.endElement("", "", "derivedAttribute");
            }
            handler.endElement("", "", "derivedAttributes");
        }
        if (!virAttrs.isEmpty()) {
            Map virAttrMap = EntityTOUtils.buildAttrMap((Collection)anyTO.getVirAttrs());
            handler.startElement("", "", "virtualAttributes", null);
            for (String attrName : virAttrs) {
                atts.clear();
                atts.addAttribute("", "", "name", "xsd:string", attrName);
                handler.startElement("", "", "virtualAttribute", atts);
                if (virAttrMap.containsKey(attrName)) {
                    for (String value : ((AttrTO)virAttrMap.get(attrName)).getValues()) {
                        handler.startElement("", "", "value", null);
                        handler.characters(value.toCharArray(), 0, value.length());
                        handler.endElement("", "", "value");
                    }
                } else {
                    LOG.debug("{} not found for {}[{}]", new Object[]{attrName, anyTO.getClass().getSimpleName(), anyTO.getKey()});
                }
                handler.endElement("", "", "virtualAttribute");
            }
            handler.endElement("", "", "virtualAttributes");
        }
    }

    private void doExtract(ContentHandler handler, List<User> users) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        for (User user : users) {
            atts.clear();
            for (UserReportletConf.Feature feature : this.conf.getFeatures()) {
                String type = null;
                Object value = null;
                switch (feature) {
                    case key: {
                        type = "xsd:string";
                        value = user.getKey();
                        break;
                    }
                    case username: {
                        type = "xsd:string";
                        value = user.getUsername();
                        break;
                    }
                    case status: {
                        type = "xsd:string";
                        value = user.getStatus();
                        break;
                    }
                    case creationDate: {
                        type = "xsd:dateTime";
                        value = user.getCreationDate() == null ? "" : FormatUtils.format((Date)user.getCreationDate());
                        break;
                    }
                    case lastLoginDate: {
                        type = "xsd:dateTime";
                        value = user.getLastLoginDate() == null ? "" : FormatUtils.format((Date)user.getLastLoginDate());
                        break;
                    }
                    case changePwdDate: {
                        type = "xsd:dateTime";
                        value = user.getChangePwdDate() == null ? "" : FormatUtils.format((Date)user.getChangePwdDate());
                        break;
                    }
                    case passwordHistorySize: {
                        type = "xsd:integer";
                        value = String.valueOf(user.getPasswordHistory().size());
                        break;
                    }
                    case failedLoginCount: {
                        type = "xsd:integer";
                        value = String.valueOf(user.getFailedLogins());
                        break;
                    }
                }
                if (type == null || value == null) continue;
                atts.addAttribute("", "", feature.name(), type, (String)value);
            }
            handler.startElement("", "", "user", atts);
            UserTO userTO = this.userDataBinder.getUserTO(user, true);
            this.doExtractAttributes(handler, (AnyTO)userTO, this.conf.getPlainAttrs(), this.conf.getDerAttrs(), this.conf.getVirAttrs());
            if (this.conf.getFeatures().contains(UserReportletConf.Feature.relationships)) {
                handler.startElement("", "", "relationships", null);
                for (RelationshipTO rel : userTO.getRelationships()) {
                    atts.clear();
                    atts.addAttribute("", "", "anyObjectKey", "xsd:string", rel.getOtherEndKey());
                    handler.startElement("", "", "relationship", atts);
                    if (this.conf.getFeatures().contains(UserReportletConf.Feature.resources)) {
                        for (URelationship actualRel : user.getRelationships(rel.getOtherEndKey())) {
                            this.doExtractResources(handler, (AnyTO)this.anyObjectDataBinder.getAnyObjectTO((AnyObject)actualRel.getRightEnd(), true));
                        }
                    }
                    handler.endElement("", "", "relationship");
                }
                handler.endElement("", "", "relationships");
            }
            if (this.conf.getFeatures().contains(UserReportletConf.Feature.memberships)) {
                handler.startElement("", "", "memberships", null);
                for (MembershipTO memb : userTO.getMemberships()) {
                    atts.clear();
                    atts.addAttribute("", "", "groupKey", "xsd:string", memb.getGroupKey());
                    atts.addAttribute("", "", "groupName", "xsd:string", memb.getGroupName());
                    handler.startElement("", "", "membership", atts);
                    if (this.conf.getFeatures().contains(UserReportletConf.Feature.resources)) {
                        UMembership actualMemb = user.getMembership(memb.getGroupKey()).orElse(null);
                        if (actualMemb == null) {
                            LOG.warn("Unexpected: cannot find membership for group {} for user {}", (Object)memb.getGroupKey(), (Object)user);
                        } else {
                            this.doExtractResources(handler, (AnyTO)this.groupDataBinder.getGroupTO((Group)actualMemb.getRightEnd(), true));
                        }
                    }
                    handler.endElement("", "", "membership");
                }
                handler.endElement("", "", "memberships");
            }
            if (this.conf.getFeatures().contains(UserReportletConf.Feature.resources)) {
                this.doExtractResources(handler, (AnyTO)userTO);
            }
            handler.endElement("", "", "user");
        }
    }

    private void doExtractConf(ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        handler.startElement("", "", "configurations", null);
        handler.startElement("", "", "userAttributes", atts);
        for (UserReportletConf.Feature feature : this.conf.getFeatures()) {
            atts.clear();
            handler.startElement("", "", "feature", atts);
            handler.characters(feature.name().toCharArray(), 0, feature.name().length());
            handler.endElement("", "", "feature");
        }
        for (String attr : this.conf.getPlainAttrs()) {
            atts.clear();
            handler.startElement("", "", "attribute", atts);
            handler.characters(attr.toCharArray(), 0, attr.length());
            handler.endElement("", "", "attribute");
        }
        for (String derAttr : this.conf.getDerAttrs()) {
            atts.clear();
            handler.startElement("", "", "derAttribute", atts);
            handler.characters(derAttr.toCharArray(), 0, derAttr.length());
            handler.endElement("", "", "derAttribute");
        }
        for (String virAttr : this.conf.getVirAttrs()) {
            atts.clear();
            handler.startElement("", "", "virAttribute", atts);
            handler.characters(virAttr.toCharArray(), 0, virAttr.length());
            handler.endElement("", "", "virAttribute");
        }
        handler.endElement("", "", "userAttributes");
        handler.endElement("", "", "configurations");
    }

    private int count() {
        return StringUtils.isBlank((CharSequence)this.conf.getMatchingCond()) ? this.userDAO.count() : this.searchDAO.count(SyncopeConstants.FULL_ADMIN_REALMS, SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)this.conf.getMatchingCond(), (String[])new String[0]), AnyTypeKind.USER);
    }

    @Override
    protected void doExtract(ReportletConf conf, ContentHandler handler, String refDesc) throws SAXException {
        if (!(conf instanceof UserReportletConf)) {
            throw new ReportException(new IllegalArgumentException("Invalid configuration provided"));
        }
        this.conf = (UserReportletConf)UserReportletConf.class.cast(conf);
        this.doExtractConf(handler);
        int total = this.count();
        int pages = total / 500 + 1;
        this.setStatus(refDesc, "Processing " + total + " users in " + pages + " pages");
        for (int page = 1; page <= pages; ++page) {
            this.setStatus(refDesc, "Processing " + total + " users: page " + page + " of " + pages);
            List users = StringUtils.isBlank((CharSequence)this.conf.getMatchingCond()) ? this.userDAO.findAll(page, 500) : this.searchDAO.search(SyncopeConstants.FULL_ADMIN_REALMS, SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)this.conf.getMatchingCond(), (String[])new String[0]), page, 500, Collections.emptyList(), AnyTypeKind.USER);
            this.doExtract(handler, users);
        }
    }
}

