/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.JobStatus;
import org.apache.syncope.core.provisioning.api.event.JobStatusEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;

public class JobStatusUpdater {
    protected static final Logger LOG = LoggerFactory.getLogger(JobStatusUpdater.class);
    @Autowired
    protected JobStatusDAO jobStatusDAO;
    @Autowired
    protected EntityFactory entityFactory;

    @Async(value="jobStatusUpdaterThreadExecutor")
    @EventListener
    public void update(JobStatusEvent event) {
        if (event.getJobStatus() == null) {
            LOG.debug("Deleting status for job '{}'", (Object)event.getJobRefDesc());
            this.jobStatusDAO.delete(event.getJobRefDesc());
        } else {
            LOG.debug("Updating job '{}' with status '{}'", (Object)event.getJobRefDesc(), (Object)event.getJobStatus());
            JobStatus jobStatus = (JobStatus)this.entityFactory.newEntity(JobStatus.class);
            jobStatus.setKey(event.getJobRefDesc());
            jobStatus.setStatus(event.getJobStatus());
            this.jobStatusDAO.save(jobStatus);
        }
    }
}

