/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.oidcclient.agent;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.common.lib.to.OIDCLogoutRequestTO;
import org.apache.syncope.common.rest.api.service.OIDCClientService;

@WebServlet(name="oidclientbeforelogout", urlPatterns={"/oidcclient/beforelogout"})
public class BeforeLogout
extends HttpServlet {
    private static final long serialVersionUID = -5920740403138557179L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Cache-Control", "no-cache, no-store");
        response.setHeader("Pragma", "no-cache");
        response.setStatus(303);
        SyncopeClientFactoryBean clientFactory = (SyncopeClientFactoryBean)request.getServletContext().getAttribute("SyncopeClientFactory");
        String accessToken = (String)request.getSession().getAttribute("oidcclient.jwt");
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            throw new IllegalArgumentException("No access token found ");
        }
        String idToken = (String)request.getSession().getAttribute("id.token");
        if (StringUtils.isBlank((CharSequence)idToken)) {
            throw new IllegalArgumentException("No id token found ");
        }
        SyncopeClient client = clientFactory.create(accessToken);
        OIDCLogoutRequestTO requestTO = ((OIDCClientService)client.getService(OIDCClientService.class)).createLogoutRequest(request.getSession().getAttribute("op").toString());
        String postLogoutRedirectURI = StringUtils.substringBefore((String)request.getRequestURL().toString(), (String)"/beforelogout") + "/logout";
        UriBuilder ub = UriBuilder.fromUri((String)requestTO.getEndSessionEndpoint());
        ub.queryParam("post_logout_redirect_uri", new Object[]{postLogoutRedirectURI});
        ub.queryParam("id_token_hint", new Object[]{idToken});
        response.setHeader("Location", ub.build(new Object[0]).toASCIIString());
    }
}

