/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.okta;

import com.okta.sdk.resource.common.PagedList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.openapitools.client.api.ApplicationApi;
import org.openapitools.client.api.GroupApi;
import org.openapitools.client.api.UserApi;
import org.openapitools.client.model.Application;
import org.openapitools.client.model.Group;
import org.openapitools.client.model.User;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;

public final class OktaPaginationApis {
    private static <T> PagedList<T> constructPagedList(ResponseEntity<List<T>> responseEntity) {
        PagedList pagedList = new PagedList();
        pagedList.addItems((List)responseEntity.getBody());
        for (String link : Optional.ofNullable(responseEntity.getHeaders().get((Object)"link")).orElse(Collections.emptyList())) {
            String[] parts = link.split("; *");
            String url = parts[0].replaceAll("<", "").replaceAll(">", "");
            String rel = parts[1];
            if (rel.equals("rel=\"next\"")) {
                pagedList.setNextPage(url);
                continue;
            }
            if (!rel.equals("rel=\"self\"")) continue;
            pagedList.setSelf(url);
        }
        return pagedList;
    }

    public static PagedList<User> listUsers(UserApi userApi, String q, String after, Integer limit, String filter, String search, String sortBy, String sortOrder) throws RestClientException {
        ResponseEntity responseEntity = userApi.listUsersWithHttpInfo(q, after, limit, filter, search, sortBy, sortOrder);
        return OktaPaginationApis.constructPagedList(responseEntity);
    }

    public static PagedList<Application> listApplications(ApplicationApi applicationApi, String q, String after, Integer limit, String filter, String expand, Boolean includeNonDeleted) throws RestClientException {
        ResponseEntity responseEntity = applicationApi.listApplicationsWithHttpInfo(q, after, limit, filter, expand, includeNonDeleted);
        return OktaPaginationApis.constructPagedList(responseEntity);
    }

    public static PagedList<Group> listGroups(GroupApi groupApi, String q, String filter, String after, Integer limit, String expand, String search) throws RestClientException {
        ResponseEntity responseEntity = groupApi.listGroupsWithHttpInfo(q, filter, after, limit, expand, search);
        return OktaPaginationApis.constructPagedList(responseEntity);
    }

    private OktaPaginationApis() {
    }
}

