/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.syncope.common.rest.api.service.PolicyService;

public class PolicyRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -1392090291817187902L;
    private static final PolicyComparator COMPARATOR = new PolicyComparator();

    public <T extends PolicyTO> T getPolicy(PolicyType type, String key) {
        PolicyTO policy = null;
        try {
            policy = PolicyRestClient.getService(PolicyService.class).read(type, key);
        }
        catch (Exception e) {
            LOG.warn("No policy found for id {}", (Object)key, (Object)e);
        }
        return (T)policy;
    }

    public <T extends PolicyTO> List<T> getPolicies(PolicyType type) {
        try {
            return PolicyRestClient.getService(PolicyService.class).list(type).stream().sorted(COMPARATOR).collect(Collectors.toList());
        }
        catch (Exception ignore) {
            LOG.debug("No policy found", (Throwable)ignore);
            return Collections.emptyList();
        }
    }

    public <T extends PolicyTO> void createPolicy(PolicyType type, T policy) {
        PolicyRestClient.getService(PolicyService.class).create(type, policy);
    }

    public <T extends PolicyTO> void updatePolicy(PolicyType type, T policy) {
        PolicyRestClient.getService(PolicyService.class).update(type, policy);
    }

    public void delete(PolicyType type, String key) {
        PolicyRestClient.getService(PolicyService.class).delete(type, key);
    }

    private static class PolicyComparator
    implements Comparator<PolicyTO>,
    Serializable {
        private static final long serialVersionUID = -4921433085213223115L;

        private PolicyComparator() {
        }

        @Override
        public int compare(PolicyTO left, PolicyTO right) {
            return left == null ? -1 : (right == null ? 1 : left.getDescription().compareTo(right.getDescription()));
        }
    }
}

