/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.util.HashMap;
import java.util.Map;
import org.apache.syncope.core.persistence.api.SyncopeLoader;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;
import org.springframework.stereotype.Component;

@Component
public class TaskExecutorUnloader
implements SyncopeLoader {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutorUnloader.class);
    private final Map<String, ExecutorConfigurationSupport> tptes = new HashMap<String, ExecutorConfigurationSupport>();

    public Integer getPriority() {
        return Integer.MIN_VALUE;
    }

    public void load() {
        this.tptes.putAll(ApplicationContextProvider.getApplicationContext().getBeansOfType(ExecutorConfigurationSupport.class));
    }

    public void unload() {
        this.tptes.forEach((name, tpte) -> {
            LOG.info("Shutting down ThreadPoolTaskExecutor {}...", name);
            try {
                tpte.shutdown();
                LOG.info("Successfully shut down ThreadPoolTaskExecutor {}", name);
            }
            catch (Exception e) {
                LOG.error("While shutting down ThreadPoolTaskExecutor {}", name, (Object)e);
            }
        });
    }
}

