/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.rewrite.RewriteAppender;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.core.logic.MemoryAppender;
import org.apache.syncope.core.logic.audit.AuditAppender;
import org.apache.syncope.core.logic.audit.DefaultAuditAppender;
import org.apache.syncope.core.logic.init.LoggerAccessor;
import org.apache.syncope.core.persistence.api.DomainsHolder;
import org.apache.syncope.core.persistence.api.ImplementationLookup;
import org.apache.syncope.core.persistence.api.SyncopeLoader;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class LoggerLoader
implements SyncopeLoader {
    private static final Logger LOG = LoggerFactory.getLogger(LoggerLoader.class);
    @Autowired
    private DomainsHolder domainsHolder;
    @Autowired
    private LoggerAccessor loggerAccessor;
    @Autowired
    private ImplementationLookup implementationLookup;
    @Value(value="${default.audit.appender:org.apache.syncope.core.logic.audit.JdbcAuditAppender}")
    private String defaultAuditAppender;
    private final Map<String, MemoryAppender> memoryAppenders = new HashMap<String, MemoryAppender>();

    public Integer getPriority() {
        return 300;
    }

    public void load() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        ctx.getConfiguration().getAppenders().entrySet().stream().filter(entry -> entry.getValue() instanceof MemoryAppender).forEach(entry -> this.memoryAppenders.put((String)entry.getKey(), (MemoryAppender)((Object)((Object)entry.getValue()))));
        this.domainsHolder.getDomains().keySet().forEach(domain -> {
            try {
                DefaultAuditAppender dfaa = (DefaultAuditAppender)ApplicationContextProvider.getBeanFactory().createBean(ClassUtils.forName((String)this.defaultAuditAppender, (ClassLoader)ClassUtils.getDefaultClassLoader()), 2, true);
                dfaa.init((String)domain);
                LoggerConfig logConf = new LoggerConfig(AuditLoggerName.getAuditLoggerName((String)domain), null, false);
                logConf.addAppender(dfaa.getTargetAppender(), Level.DEBUG, null);
                logConf.setLevel(Level.DEBUG);
                ctx.getConfiguration().addLogger(logConf.getName(), logConf);
            }
            catch (Exception e) {
                LOG.error("While creating instance of DefaultAuditAppender {}", (Object)this.defaultAuditAppender, (Object)e);
            }
            this.auditAppenders((String)domain).forEach(auditAppender -> auditAppender.getEvents().stream().map(event -> AuditLoggerName.getAuditEventLoggerName((String)domain, (String)event.toLoggerName())).forEach(domainAuditLoggerName -> {
                LoggerConfig eventLogConf = ctx.getConfiguration().getLoggerConfig(domainAuditLoggerName);
                boolean isRootLogConf = "".equals(eventLogConf.getName());
                if (isRootLogConf) {
                    eventLogConf = new LoggerConfig(domainAuditLoggerName, null, false);
                }
                this.addAppenderToContext(ctx, (AuditAppender)auditAppender, eventLogConf);
                eventLogConf.setLevel(Level.DEBUG);
                if (isRootLogConf) {
                    ctx.getConfiguration().addLogger(domainAuditLoggerName, eventLogConf);
                }
            }));
            AuthContextUtils.execWithAuthContext((String)domain, () -> {
                this.loggerAccessor.synchronizeLog4J(ctx);
                return null;
            });
        });
        ctx.updateLoggers();
    }

    public Map<String, MemoryAppender> getMemoryAppenders() {
        return this.memoryAppenders;
    }

    public List<AuditAppender> auditAppenders(String domain) throws BeansException {
        return this.implementationLookup.getAuditAppenderClasses().stream().map(clazz -> {
            AuditAppender auditAppender;
            if (ApplicationContextProvider.getBeanFactory().containsSingleton(clazz.getName())) {
                auditAppender = (AuditAppender)ApplicationContextProvider.getBeanFactory().getSingleton(clazz.getName());
            } else {
                auditAppender = (AuditAppender)ApplicationContextProvider.getBeanFactory().createBean(clazz, 2, true);
                auditAppender.init(domain);
            }
            return auditAppender;
        }).collect(Collectors.toList());
    }

    public void addAppenderToContext(LoggerContext ctx, AuditAppender auditAppender, LoggerConfig eventLogConf) {
        Appender targetAppender = ctx.getConfiguration().getAppender(auditAppender.getTargetAppenderName());
        if (targetAppender == null) {
            targetAppender = auditAppender.getTargetAppender();
        }
        targetAppender.start();
        ctx.getConfiguration().addAppender(targetAppender);
        Optional<RewriteAppender> rewriteAppender = auditAppender.getRewriteAppender();
        if (rewriteAppender.isPresent()) {
            rewriteAppender.get().start();
            eventLogConf.addAppender((Appender)rewriteAppender.get(), Level.DEBUG, null);
        } else {
            eventLogConf.addAppender(targetAppender, Level.DEBUG, null);
        }
    }
}

