/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.common.lib.types.LoggerLevel;
import org.apache.syncope.common.lib.types.LoggerType;
import org.apache.syncope.core.persistence.api.dao.LoggerDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Logger;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LoggerAccessor {
    @Autowired
    private LoggerDAO loggerDAO;
    @Autowired
    private EntityFactory entityFactory;

    @Transactional
    public void synchronizeLog4J(LoggerContext ctx) {
        HashMap<String, Logger> syncopeLoggers = new HashMap<String, Logger>();
        if ("Master".equals(AuthContextUtils.getDomain())) {
            for (Logger logger : this.loggerDAO.findAll(LoggerType.LOG)) {
                syncopeLoggers.put(logger.getKey(), logger);
            }
        }
        for (Logger logger : this.loggerDAO.findAll(LoggerType.AUDIT)) {
            syncopeLoggers.put(AuditLoggerName.getAuditEventLoggerName((String)AuthContextUtils.getDomain(), (String)logger.getKey()), logger);
        }
        for (LoggerConfig loggerConfig : ctx.getConfiguration().getLoggers().values()) {
            String loggerName;
            String string = loggerName = "".equals(loggerConfig.getName()) ? "ROOT" : loggerConfig.getName();
            if (loggerConfig.getLevel() == null) continue;
            if (syncopeLoggers.containsKey(loggerName)) {
                loggerConfig.setLevel(((Logger)syncopeLoggers.get(loggerName)).getLevel().getLevel());
                syncopeLoggers.remove(loggerName);
                continue;
            }
            if (loggerName.startsWith(LoggerType.AUDIT.getPrefix()) && loggerName.startsWith(AuthContextUtils.getDomain() + "." + LoggerType.AUDIT.getPrefix())) continue;
            Logger syncopeLogger = (Logger)this.entityFactory.newEntity(Logger.class);
            syncopeLogger.setKey(loggerName);
            syncopeLogger.setLevel(LoggerLevel.fromLevel((Level)loggerConfig.getLevel()));
            syncopeLogger.setType(LoggerType.LOG);
            this.loggerDAO.save(syncopeLogger);
        }
        for (Map.Entry entry : syncopeLoggers.entrySet()) {
            LoggerConfig logConf = ctx.getConfiguration().getLoggerConfig((String)entry.getKey());
            logConf.setLevel(((Logger)entry.getValue()).getLevel().getLevel());
        }
        ctx.updateLoggers();
    }
}

