/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.util;

import de.agilecoders.wicket.webjars.WicketWebjars;
import de.agilecoders.wicket.webjars.settings.IWebjarsSettings;
import de.agilecoders.wicket.webjars.util.RecentVersionCallable;
import de.agilecoders.wicket.webjars.util.WebJarAssetLocator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebjarsVersion {
    private static final Logger LOG = LoggerFactory.getLogger(WicketWebjars.class);
    private static final ConcurrentMap<String, FutureTask<String>> VERSIONS_CACHE = new ConcurrentHashMap<String, FutureTask<String>>();

    public static String useRecent(String path) {
        Args.notEmpty((CharSequence)path, (String)"path");
        if (path.matches(Holder.recentVersionPattern)) {
            return path.replaceFirst(Holder.replacePattern, "/" + WebjarsVersion.recentVersion(path) + "/");
        }
        return path;
    }

    public static String recentVersion(String partialPath) {
        FutureTask<String> futureTask;
        FutureTask<String> prevFutureTask;
        if (!VERSIONS_CACHE.containsKey(partialPath) && (prevFutureTask = VERSIONS_CACHE.putIfAbsent(partialPath, futureTask = RecentVersionCallable.createFutureTask(partialPath))) == null) {
            futureTask.run();
        }
        try {
            return (String)((FutureTask)VERSIONS_CACHE.get(partialPath)).get(Holder.timeout.getMilliseconds(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("can't collect recent version of {}; {}", (Object)partialPath, (Object)e.getMessage());
            throw new WebJarAssetLocator.ResourceException(partialPath, "there is no webjars dependency for: " + partialPath);
        }
    }

    public static void reset() {
        VERSIONS_CACHE.clear();
    }

    private WebjarsVersion() {
        throw new UnsupportedOperationException();
    }

    private static final class Holder {
        private static final IWebjarsSettings settings = WicketWebjars.settings();
        private static final String recentVersionPattern = "/webjars/[^/]*/" + settings.recentVersionPlaceHolder() + "/.*";
        private static final String replacePattern = "/" + settings.recentVersionPlaceHolder() + "/";
        private static final Duration timeout = settings.readFromCacheTimeout();

        private Holder() {
        }
    }
}

