/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.user;

import java.util.List;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.user.AbstractUserCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.UserTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSearchByResource
extends AbstractUserCommand {
    private static final Logger LOG = LoggerFactory.getLogger(UserSearchByResource.class);
    private static final String SEARCH_HELP_MESSAGE = "user --search-by-resource {REALM} {RESOURCE-KEY}";
    private final Input input;

    public UserSearchByResource(Input input) {
        this.input = input;
    }

    public void search() {
        block8: {
            if (this.input.parameterNumber() == 2) {
                String realm = this.input.firstParameter();
                String resource = this.input.secondParameter();
                try {
                    List<UserTO> userTOs = null;
                    if (!this.realmSyncopeOperations.exists(realm)) {
                        this.userResultManager.genericMessage("Operation performed on root realm because " + realm + " does not exists");
                    }
                    if (!this.resourceSyncopeOperations.exists(resource)) {
                        this.userResultManager.notFoundError("Resource", resource);
                    } else {
                        userTOs = this.userSyncopeOperations.searchByResource(realm, resource);
                    }
                    if (userTOs == null || userTOs.isEmpty()) {
                        this.userResultManager.genericMessage("No users has " + resource + " assigned");
                        break block8;
                    }
                    this.userResultManager.printUsers(userTOs);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error searching user", ex);
                    this.userResultManager.genericError(ex.getMessage());
                    this.userResultManager.genericError(SEARCH_HELP_MESSAGE);
                }
            } else {
                this.userResultManager.commandOptionError(SEARCH_HELP_MESSAGE);
            }
        }
    }
}

