/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.role;

import java.util.ArrayList;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.role.AbstractRoleCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.RoleTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleRead
extends AbstractRoleCommand {
    private static final Logger LOG = LoggerFactory.getLogger(RoleRead.class);
    private static final String READ_HELP_MESSAGE = "role --read {ROLE-KEY} {ROLE-KEY} [...]";
    private final Input input;

    public RoleRead(Input input) {
        this.input = input;
    }

    public void read() {
        if (this.input.getParameters().length >= 1) {
            ArrayList<RoleTO> roleTOs = new ArrayList<RoleTO>();
            for (String parameter : this.input.getParameters()) {
                try {
                    roleTOs.add(this.roleSyncopeOperations.read(parameter));
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error reading role", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.roleResultManager.notFoundError("Role", parameter);
                        break;
                    }
                    this.roleResultManager.genericError(ex.getMessage());
                    break;
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error reading role", (Throwable)ex);
                    this.roleResultManager.numberFormatException("user", parameter);
                }
            }
            this.roleResultManager.printRoles(roleTOs);
        } else {
            this.roleResultManager.commandOptionError(READ_HELP_MESSAGE);
        }
    }
}

