/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.group;

import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.group.AbstractGroupCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupRead
extends AbstractGroupCommand {
    private static final Logger LOG = LoggerFactory.getLogger(GroupRead.class);
    private static final String READ_HELP_MESSAGE = "group --read {GROUP-KEY} {GROUP-KEY} [...]";
    private final Input input;

    public GroupRead(Input input) {
        this.input = input;
    }

    public void read() {
        if (this.input.parameterNumber() >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.groupResultManager.printGroup(this.groupSyncopeOperations.read(parameter));
                }
                catch (SyncopeClientException ex) {
                    LOG.error("Error reading group", (Throwable)ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.groupResultManager.notFoundError("Group", parameter);
                        continue;
                    }
                    this.groupResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    this.groupResultManager.numberFormatException("group", parameter);
                }
            }
        } else {
            this.groupResultManager.commandOptionError(READ_HELP_MESSAGE);
        }
    }
}

