angular.module("uib/template/datepicker/year.html", []).run(["$templateCache", function ($templateCache) {
  $templateCache.put("uib/template/datepicker/year.html",
    "<table role=\"grid\" aria-labelledby=\"{{::uniqueId}}-title\" aria-activedescendant=\"{{activeDateId}}\">\n" +
    "  <thead>\n" +
    "  <tr>\n" +
    "    <th>\n" +
    "      <button type=\"button\" class=\"btn btn-secondary btn-sm float-left uib-left\" ng-click=\"move(-1)\" tabindex=\"-1\">\n" +
    "        <i aria-hidden=\"true\" class=\"fa-svg-icon\">\n" +
    "          <svg width=\"1792\" height=\"1792\" viewBox=\"0 0 1792 1792\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M1427 301l-531 531 531 531q19 19 19 45t-19 45l-166 166q-19 19-45 19t-45-19l-742-742q-19-19-19-45t19-45l742-742q19-19 45-19t45 19l166 166q19 19 19 45t-19 45z\"/></svg>\n" +
    "        </i>\n" +
    "        <span class=\"sr-only\">previous</span>\n" +
    "      </button>\n" +
    "    </th>\n" +
    "    <th colspan=\"{{::columns - 2}}\">\n" +
    "      <button id=\"{{::uniqueId}}-title\" role=\"heading\" aria-live=\"assertive\" aria-atomic=\"true\" type=\"button\"\n" +
    "              class=\"btn btn-secondary btn-sm uib-title\" ng-click=\"toggleMode()\"\n" +
    "              ng-disabled=\"datepickerMode === maxMode\" tabindex=\"-1\">\n" +
    "        <strong>{{title}}</strong>\n" +
    "      </button>\n" +
    "    </th>\n" +
    "    <th>\n" +
    "      <button type=\"button\" class=\"btn btn-secondary btn-sm float-right uib-right\" ng-click=\"move(1)\" tabindex=\"-1\">\n" +
    "        <i aria-hidden=\"true\" class=\"fa-svg-icon\">\n" +
    "          <svg width=\"1792\" height=\"1792\" viewBox=\"0 0 1792 1792\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M1363 877l-742 742q-19 19-45 19t-45-19l-166-166q-19-19-19-45t19-45l531-531-531-531q-19-19-19-45t19-45l166-166q19-19 45-19t45 19l742 742q19 19 19 45t-19 45z\"/></svg>\n" +
    "        </i>\n" +
    "        <span class=\"sr-only\">next</span>\n" +
    "      </button>\n" +
    "    </th>\n" +
    "  </tr>\n" +
    "  </thead>\n" +
    "  <tbody>\n" +
    "  <tr class=\"uib-years\" ng-repeat=\"row in rows track by $index\" role=\"row\">\n" +
    "    <td ng-repeat=\"dt in row\" class=\"uib-year text-center\" role=\"gridcell\"\n" +
    "        id=\"{{::dt.uid}}\"\n" +
    "        ng-class=\"::dt.customClass\">\n" +
    "      <button type=\"button\" class=\"btn btn-secondary\"\n" +
    "              uib-is-class=\"\n" +
    "            'btn-info' for selectedDt,\n" +
    "            'active' for activeDt\n" +
    "            on dt\"\n" +
    "              ng-click=\"select(dt.date)\"\n" +
    "              ng-disabled=\"::dt.disabled\"\n" +
    "              tabindex=\"-1\"><span ng-class=\"::{'text-info': dt.current}\">{{::dt.label}}</span></button>\n" +
    "    </td>\n" +
    "  </tr>\n" +
    "  </tbody>\n" +
    "</table>\n" +
    "");
}]);
