/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.PathParam;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ItemContainerTO;
import org.apache.syncope.common.lib.to.ItemTO;
import org.apache.syncope.common.lib.to.UserTO;

@XmlRootElement(name="oidcprovider")
@XmlType
public class OIDCProviderTO
implements EntityTO,
ItemContainerTO {
    private static final long serialVersionUID = -1229802774546135794L;
    private String key;
    private String name;
    private String clientID;
    private String clientSecret;
    private String authorizationEndpoint;
    private String tokenEndpoint;
    private String jwksUri;
    private String issuer;
    private String userinfoEndpoint;
    private String endSessionEndpoint;
    private boolean hasDiscovery;
    private UserTO userTemplate;
    private boolean createUnmatching;
    private boolean updateMatching;
    private boolean selfRegUnmatching;
    private final List<ItemTO> items = new ArrayList<ItemTO>();
    private final Set<String> actionsClassNames = new HashSet<String>();

    public String getKey() {
        return this.key;
    }

    @PathParam(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    public void setUserinfoEndpoint(String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
    }

    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public void setEndSessionEndpoint(String endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
    }

    public UserTO getUserTemplate() {
        return this.userTemplate;
    }

    public boolean getHasDiscovery() {
        return this.hasDiscovery;
    }

    public void setHasDiscovery(boolean hasDiscovery) {
        this.hasDiscovery = hasDiscovery;
    }

    public void setUserTemplate(UserTO userTemplate) {
        this.userTemplate = userTemplate;
    }

    public boolean isCreateUnmatching() {
        return this.createUnmatching;
    }

    public void setCreateUnmatching(boolean createUnmatching) {
        this.createUnmatching = createUnmatching;
    }

    public boolean isUpdateMatching() {
        return this.updateMatching;
    }

    public void setUpdateMatching(boolean updateMatching) {
        this.updateMatching = updateMatching;
    }

    public boolean isSelfRegUnmatching() {
        return this.selfRegUnmatching;
    }

    public void setSelfRegUnmatching(boolean selfRegUnmatching) {
        this.selfRegUnmatching = selfRegUnmatching;
    }

    public ItemTO getConnObjectKeyItem() {
        return this.getItems().stream().filter(item -> item.isConnObjectKey()).findFirst().orElse(null);
    }

    protected boolean addConnObjectKeyItem(ItemTO connObjectItem) {
        connObjectItem.setMandatoryCondition("true");
        connObjectItem.setConnObjectKey(true);
        return this.add(connObjectItem);
    }

    public boolean setConnObjectKeyItem(ItemTO connObjectKeyItem) {
        return connObjectKeyItem == null ? this.remove(this.getConnObjectKeyItem()) : this.addConnObjectKeyItem(connObjectKeyItem);
    }

    @XmlElementWrapper(name="items")
    @XmlElement(name="item")
    @JsonProperty(value="items")
    public List<ItemTO> getItems() {
        return this.items;
    }

    public boolean add(ItemTO item) {
        return item == null ? false : this.items.contains(item) || this.items.add(item);
    }

    public boolean remove(ItemTO item) {
        return this.items.remove(item);
    }

    @XmlElementWrapper(name="actionsClassNames")
    @XmlElement(name="actionsClassName")
    @JsonProperty(value="actionsClassNames")
    public Set<String> getActionsClassNames() {
        return this.actionsClassNames;
    }
}

