/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.info.NumbersInfo;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.info.SystemInfo;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.rest.api.Preference;
import org.apache.syncope.common.rest.api.RESTHeaders;
import org.apache.syncope.common.rest.api.batch.BatchItem;
import org.apache.syncope.common.rest.api.batch.BatchPayloadParser;
import org.apache.syncope.common.rest.api.batch.BatchRequestItem;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.apache.syncope.core.logic.SyncopeLogic;
import org.apache.syncope.core.persistence.api.dao.BatchDAO;
import org.apache.syncope.core.persistence.api.dao.EntityCacheDAO;
import org.apache.syncope.core.persistence.api.entity.Batch;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.rest.cxf.batch.BatchProcess;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class SyncopeServiceImpl
extends AbstractServiceImpl
implements SyncopeService {
    @Resource(name="batchExecutor")
    private ThreadPoolTaskExecutor batchExecutor;
    @Autowired
    private SyncopeLogic logic;
    @Autowired
    private Bus bus;
    @Autowired
    private BatchDAO batchDAO;
    @Autowired
    private EntityCacheDAO entityCacheDAO;
    @Autowired
    private EntityFactory entityFactory;

    public PlatformInfo platform() {
        return this.logic.platform();
    }

    public SystemInfo system() {
        return this.logic.system();
    }

    public NumbersInfo numbers() {
        return this.logic.numbers();
    }

    public Map<String, Object> statistics() {
        return this.entityCacheDAO.getStatistics();
    }

    public Response statistics(String operation) {
        switch (operation) {
            case "enable": 
            case "ENABLE": {
                this.entityCacheDAO.enableStatistics();
                break;
            }
            case "disable": 
            case "DISABLE": {
                this.entityCacheDAO.disableStatistics();
                break;
            }
            case "reset": 
            case "RESET": {
                this.entityCacheDAO.resetStatistics();
                break;
            }
            default: {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).header("X-Application-Error-Info", (Object)("Unsupported Operation: " + operation)).build();
            }
        }
        return Response.noContent().build();
    }

    public void clearEntityCache() {
        this.entityCacheDAO.clearCache();
    }

    public PagedResult<GroupTO> searchAssignableGroups(String realm, String term, int page, int size) {
        Pair result = this.logic.searchAssignableGroups(StringUtils.prependIfMissing((String)realm, (CharSequence)"/", (CharSequence[])new CharSequence[0]), term, page, size);
        return this.buildPagedResult((List)result.getRight(), page, size, (Integer)result.getLeft());
    }

    public TypeExtensionTO readUserTypeExtension(String groupName) {
        return this.logic.readTypeExtension(groupName);
    }

    private DestinationRegistry getDestinationRegistryFromBusOrDefault() {
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        try {
            HTTPTransportFactory df = (HTTPTransportFactory)dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
            return df.getRegistry();
        }
        catch (Exception e) {
            throw new InternalServerErrorException("Could not find CXF's DestinationRegistry", (Throwable)e);
        }
    }

    public Response batch(InputStream input) {
        List batchRequestItems;
        MediaType mediaType = MediaType.valueOf((String)this.messageContext.getHttpServletRequest().getContentType());
        String boundary = (String)mediaType.getParameters().get("boundary");
        if (this.batchDAO.find(boundary) != null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.EntityExists);
            sce.getElements().add("Batch with boundary " + boundary + " already processing");
            throw sce;
        }
        try {
            batchRequestItems = BatchPayloadParser.parse((InputStream)input, (MediaType)mediaType, (BatchItem)new BatchRequestItem());
        }
        catch (IOException e) {
            LOG.error("Could not parse batch request with boundary {}", (Object)boundary, (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidEntity);
            sce.getElements().add("Batch request with boundary " + boundary);
            throw sce;
        }
        Batch batch = (Batch)this.entityFactory.newEntity(Batch.class);
        batch.setKey(boundary);
        batch.setExpiryTime(new Date(System.currentTimeMillis() + 300000L));
        this.batchDAO.save(batch);
        BatchProcess batchProcess = (BatchProcess)ApplicationContextProvider.getBeanFactory().createBean(BatchProcess.class);
        batchProcess.setBoundary(boundary);
        batchProcess.setBasePath(this.uriInfo.getBaseUri().toASCIIString());
        batchProcess.setBatchRequestItems(batchRequestItems);
        batchProcess.setDestinationRegistry(this.getDestinationRegistryFromBusOrDefault());
        batchProcess.setServletConfig(this.messageContext.getServletConfig());
        batchProcess.setServletRequest(this.messageContext.getHttpServletRequest());
        batchProcess.setAuthentication(SecurityContextHolder.getContext().getAuthentication());
        if (this.getPreference() == Preference.RESPOND_ASYNC) {
            this.batchExecutor.execute((Runnable)batchProcess);
            return Response.accepted().header("Preference-Applied", (Object)this.getPreference().toString()).header("Location", (Object)this.uriInfo.getAbsolutePathBuilder().build(new Object[0])).type(RESTHeaders.multipartMixedWith((String)boundary)).build();
        }
        batchProcess.run();
        return this.batch();
    }

    public Response batch() {
        MediaType mediaType = MediaType.valueOf((String)this.messageContext.getHttpServletRequest().getContentType());
        String boundary = (String)mediaType.getParameters().get("boundary");
        Batch batch = this.batchDAO.find(boundary);
        if (batch == null) {
            throw new NotFoundException("Batch " + boundary);
        }
        if (batch.getResults() == null) {
            return Response.accepted().type(RESTHeaders.multipartMixedWith((String)boundary)).header("Retry-After", (Object)5).header("Location", (Object)this.uriInfo.getAbsolutePathBuilder().build(new Object[0])).build();
        }
        Response response = Response.ok((Object)batch.getResults()).type(RESTHeaders.multipartMixedWith((String)boundary)).build();
        this.batchDAO.delete(boundary);
        return response;
    }
}

