/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityExistsException;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;
import javax.validation.ValidationException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.validation.ValidationExceptionMapper;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ErrorTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidEntityException;
import org.apache.syncope.core.persistence.api.attrvalue.validation.ParsingValidationException;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.MalformedPathException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.apache.syncope.core.workflow.api.WorkflowException;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.transaction.TransactionSystemException;

@Configuration
@PropertySource(value={"classpath:errorMessages.properties"})
@Provider
public class RestServiceExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger LOG = LoggerFactory.getLogger(RestServiceExceptionMapper.class);
    private final ValidationExceptionMapper validationEM = new ValidationExceptionMapper();
    @Autowired
    private Environment env;
    private static final String UNIQUE_MSG_KEY = "UniqueConstraintViolation";
    private static final Map<String, String> EXCEPTION_CODE_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = -7688359318035249200L;
        {
            this.put("23000", RestServiceExceptionMapper.UNIQUE_MSG_KEY);
            this.put("23505", RestServiceExceptionMapper.UNIQUE_MSG_KEY);
        }
    };

    public Response toResponse(Exception ex) {
        Response.ResponseBuilder builder;
        LOG.error("Exception thrown", (Throwable)ex);
        if (ex instanceof AccessDeniedException) {
            builder = null;
        } else if (ex instanceof SyncopeClientException) {
            SyncopeClientException sce = (SyncopeClientException)ex;
            builder = sce.isComposite() ? this.getSyncopeClientCompositeExceptionResponse(sce.asComposite()) : this.getSyncopeClientExceptionResponse(sce);
        } else if (ex instanceof DelegatedAdministrationException || ExceptionUtils.getRootCause((Throwable)ex) instanceof DelegatedAdministrationException) {
            builder = this.builder(ClientExceptionType.DelegatedAdministration, ExceptionUtils.getRootCauseMessage((Throwable)ex));
        } else if (ex instanceof EntityExistsException || ex instanceof DuplicateException || ex instanceof PersistenceException && ex.getCause() instanceof EntityExistsException) {
            builder = this.builder(ClientExceptionType.EntityExists, this.getPersistenceErrorMessage(ex instanceof PersistenceException ? ex.getCause() : ex));
        } else if (ex instanceof DataIntegrityViolationException || ex instanceof JpaSystemException) {
            builder = this.builder(ClientExceptionType.DataIntegrityViolation, this.getPersistenceErrorMessage(ex));
        } else if (ex instanceof ConnectorException) {
            builder = this.builder(ClientExceptionType.ConnectorException, ExceptionUtils.getRootCauseMessage((Throwable)ex));
        } else if (ex instanceof NotFoundException) {
            builder = this.builder(ClientExceptionType.NotFound, ExceptionUtils.getRootCauseMessage((Throwable)ex));
        } else {
            builder = this.processInvalidEntityExceptions(ex);
            if (builder == null) {
                builder = this.processBadRequestExceptions(ex);
            }
            if (builder == null && ex instanceof ValidationException) {
                builder = this.builder(this.validationEM.toResponse((ValidationException)ex)).header("X-Application-Error-Code", (Object)ClientExceptionType.RESTValidation.name()).header("X-Application-Error-Info", (Object)ClientExceptionType.RESTValidation.getInfoHeaderValue(ExceptionUtils.getRootCauseMessage((Throwable)ex)));
            }
            if (builder == null && ex instanceof WebApplicationException) {
                builder = this.builder(((WebApplicationException)ex).getResponse()).header("X-Application-Error-Code", (Object)ClientExceptionType.Unknown.name()).header("X-Application-Error-Info", (Object)ClientExceptionType.Unknown.getInfoHeaderValue(ExceptionUtils.getRootCauseMessage((Throwable)ex)));
            }
            if (builder == null) {
                builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("X-Application-Error-Code", (Object)ClientExceptionType.Unknown.name()).header("X-Application-Error-Info", (Object)ClientExceptionType.Unknown.getInfoHeaderValue(ExceptionUtils.getRootCauseMessage((Throwable)ex)));
                ErrorTO error = new ErrorTO();
                error.setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                error.setType(ClientExceptionType.Unknown);
                error.getElements().add(ExceptionUtils.getRootCauseMessage((Throwable)ex));
                builder.entity((Object)error);
            }
        }
        return builder == null ? null : builder.build();
    }

    private Response.ResponseBuilder getSyncopeClientExceptionResponse(SyncopeClientException ex) {
        Response.ResponseBuilder builder = Response.status((Response.Status)ex.getType().getResponseStatus());
        builder.header("X-Application-Error-Code", (Object)ex.getType().name());
        ErrorTO error = new ErrorTO();
        error.setStatus(ex.getType().getResponseStatus().getStatusCode());
        error.setType(ex.getType());
        ex.getElements().forEach(element -> {
            builder.header("X-Application-Error-Info", (Object)ex.getType().getInfoHeaderValue(element));
            error.getElements().add(element);
        });
        return builder.entity((Object)error);
    }

    private Response.ResponseBuilder getSyncopeClientCompositeExceptionResponse(SyncopeClientCompositeException ex) {
        if (ex.getExceptions().size() == 1) {
            return this.getSyncopeClientExceptionResponse((SyncopeClientException)ex.getExceptions().iterator().next());
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
        ArrayList errors = new ArrayList();
        ex.getExceptions().stream().map(sce -> {
            builder.header("X-Application-Error-Code", (Object)sce.getType().name());
            ErrorTO error = new ErrorTO();
            error.setStatus(sce.getType().getResponseStatus().getStatusCode());
            error.setType(sce.getType());
            sce.getElements().forEach(element -> {
                builder.header("X-Application-Error-Info", (Object)sce.getType().getInfoHeaderValue(element));
                error.getElements().add(element);
            });
            return error;
        }).collect(Collectors.toList());
        return builder.entity(errors);
    }

    private Response.ResponseBuilder processInvalidEntityExceptions(Exception ex) {
        InvalidEntityException iee = null;
        if (ex instanceof InvalidEntityException) {
            iee = (InvalidEntityException)ex;
        }
        if (ex instanceof TransactionSystemException && ex.getCause() instanceof RollbackException && ex.getCause().getCause() instanceof InvalidEntityException) {
            iee = (InvalidEntityException)ex.getCause().getCause();
        }
        if (iee != null) {
            ClientExceptionType exType;
            if (iee.getEntityClassSimpleName().endsWith("Policy")) {
                exType = ClientExceptionType.InvalidPolicy;
            } else if (iee.getEntityClassSimpleName().equals(PlainAttr.class.getSimpleName())) {
                exType = ClientExceptionType.InvalidValues;
            } else {
                try {
                    exType = ClientExceptionType.valueOf((String)("Invalid" + iee.getEntityClassSimpleName()));
                }
                catch (IllegalArgumentException e) {
                    exType = ClientExceptionType.InvalidEntity;
                }
            }
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            builder.header("X-Application-Error-Code", (Object)exType.name());
            ErrorTO error = new ErrorTO();
            error.setStatus(exType.getResponseStatus().getStatusCode());
            error.setType(exType);
            for (Map.Entry violation : iee.getViolations().entrySet()) {
                for (EntityViolationType violationType : (Set)violation.getValue()) {
                    builder.header("X-Application-Error-Info", (Object)exType.getInfoHeaderValue(violationType.name() + ": " + violationType.getMessage()));
                    error.getElements().add(violationType.name() + ": " + violationType.getMessage());
                }
            }
            return builder;
        }
        return null;
    }

    private Response.ResponseBuilder processBadRequestExceptions(Exception ex) {
        Class<?> ibatisPersistenceException = null;
        try {
            ibatisPersistenceException = Class.forName("org.apache.ibatis.exceptions.PersistenceException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (ex instanceof WorkflowException) {
            return this.builder(ClientExceptionType.Workflow, ExceptionUtils.getRootCauseMessage((Throwable)ex));
        }
        if (ex instanceof PersistenceException) {
            return this.builder(ClientExceptionType.GenericPersistence, ExceptionUtils.getRootCauseMessage((Throwable)ex));
        }
        if (ibatisPersistenceException != null && ibatisPersistenceException.isAssignableFrom(ex.getClass())) {
            return this.builder(ClientExceptionType.Workflow, "Currently unavailable. Please try later.");
        }
        if (ex instanceof JpaSystemException) {
            return this.builder(ClientExceptionType.DataIntegrityViolation, ExceptionUtils.getRootCauseMessage((Throwable)ex));
        }
        if (ex instanceof ConfigurationException) {
            return this.builder(ClientExceptionType.InvalidConnIdConf, ExceptionUtils.getRootCauseMessage((Throwable)ex));
        }
        if (ex instanceof ParsingValidationException) {
            return this.builder(ClientExceptionType.InvalidValues, ExceptionUtils.getRootCauseMessage((Throwable)ex));
        }
        if (ex instanceof MalformedPathException) {
            return this.builder(ClientExceptionType.InvalidPath, ExceptionUtils.getRootCauseMessage((Throwable)ex));
        }
        return null;
    }

    private Response.ResponseBuilder builder(ClientExceptionType hType, String msg) {
        Response.ResponseBuilder builder = Response.status((Response.Status)hType.getResponseStatus()).header("X-Application-Error-Code", (Object)hType.name()).header("X-Application-Error-Info", (Object)hType.getInfoHeaderValue(msg));
        ErrorTO error = new ErrorTO();
        error.setStatus(hType.getResponseStatus().getStatusCode());
        error.setType(hType);
        error.getElements().add(msg);
        return builder.entity((Object)error);
    }

    private Response.ResponseBuilder builder(Response response) {
        Response.ResponseBuilder builder = JAXRSUtils.toResponseBuilder((int)response.getStatus());
        builder.entity(response.getEntity());
        response.getMetadata().forEach((key, value) -> {
            if (!"Content-Type".equals(key)) {
                value.forEach(headerValue -> builder.header(key, headerValue));
            }
        });
        return builder;
    }

    private String getPersistenceErrorMessage(Throwable ex) {
        Throwable throwable = ExceptionUtils.getRootCause((Throwable)ex);
        String message = null;
        if (throwable instanceof SQLException) {
            String messageKey = EXCEPTION_CODE_MAP.get(((SQLException)throwable).getSQLState());
            if (messageKey != null) {
                message = this.env.getProperty("errMessage." + messageKey);
            }
        } else if (throwable instanceof EntityExistsException || throwable instanceof DuplicateException) {
            message = this.env.getProperty("errMessage.UniqueConstraintViolation");
        }
        return message == null ? (ex.getCause() == null ? ex.getMessage() : ex.getCause().getMessage()) : message;
    }
}

