/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import java.text.ParseException;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.SchedTaskCheck;
import org.quartz.CronExpression;

public class SchedTaskValidator
extends AbstractValidator<SchedTaskCheck, SchedTask> {
    public boolean isValid(SchedTask task, ConstraintValidatorContext context) {
        boolean isValid = true;
        if (task.getCronExpression() != null) {
            try {
                new CronExpression(task.getCronExpression());
            }
            catch (ParseException e) {
                LOG.error("Invalid cron expression '" + task.getCronExpression() + "'", (Throwable)e);
                isValid = false;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidSchedTask, "Invalid cron expression")).addPropertyNode("cronExpression").addConstraintViolation();
            }
        }
        return isValid;
    }
}

