/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.PropagationPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PullPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PushPolicy;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.policy.AbstractPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAAccountPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPasswordPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPropagationPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPullCorrelationRuleEntity;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPullPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPushCorrelationRuleEntity;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPushPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository
public class JPAPolicyDAO
extends AbstractDAO<Policy>
implements PolicyDAO {
    @Autowired
    @Lazy
    private RealmDAO realmDAO;
    @Autowired
    @Lazy
    private ExternalResourceDAO resourceDAO;

    private <T extends Policy> Class<? extends AbstractPolicy> getEntityReference(Class<T> reference) {
        return AccountPolicy.class.isAssignableFrom(reference) ? JPAAccountPolicy.class : (PasswordPolicy.class.isAssignableFrom(reference) ? JPAPasswordPolicy.class : (PropagationPolicy.class.isAssignableFrom(reference) ? JPAPropagationPolicy.class : (PullPolicy.class.isAssignableFrom(reference) ? JPAPullPolicy.class : (PushPolicy.class.isAssignableFrom(reference) ? JPAPushPolicy.class : null))));
    }

    public <T extends Policy> T find(String key) {
        return (T)((Policy)this.entityManager().find(AbstractPolicy.class, (Object)key));
    }

    public <T extends Policy> List<T> find(Class<T> reference) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + this.getEntityReference(reference).getSimpleName() + " e", reference);
        return query.getResultList();
    }

    public List<AccountPolicy> findByAccountRule(Implementation accountRule) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAAccountPolicy.class.getSimpleName() + " e WHERE :accountRule MEMBER OF e.rules", AccountPolicy.class);
        query.setParameter("accountRule", (Object)accountRule);
        return query.getResultList();
    }

    public List<PasswordPolicy> findByPasswordRule(Implementation passwordRule) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAPasswordPolicy.class.getSimpleName() + " e WHERE :passwordRule MEMBER OF e.rules", PasswordPolicy.class);
        query.setParameter("passwordRule", (Object)passwordRule);
        return query.getResultList();
    }

    public List<PullPolicy> findByPullCorrelationRule(Implementation correlationRule) {
        TypedQuery query = this.entityManager().createQuery("SELECT DISTINCT e.pullPolicy FROM " + JPAPullCorrelationRuleEntity.class.getSimpleName() + " e WHERE e.implementation=:correlationRule", PullPolicy.class);
        query.setParameter("correlationRule", (Object)correlationRule);
        return query.getResultList();
    }

    public List<PushPolicy> findByPushCorrelationRule(Implementation correlationRule) {
        TypedQuery query = this.entityManager().createQuery("SELECT DISTINCT e.pushPolicy FROM " + JPAPushCorrelationRuleEntity.class.getSimpleName() + " e WHERE e.implementation=:correlationRule", PushPolicy.class);
        query.setParameter("correlationRule", (Object)correlationRule);
        return query.getResultList();
    }

    public List<AccountPolicy> findByResource(ExternalResource resource) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAAccountPolicy.class.getSimpleName() + " e WHERE :resource MEMBER OF e.resources", AccountPolicy.class);
        query.setParameter("resource", (Object)resource);
        return query.getResultList();
    }

    public List<Policy> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + AbstractPolicy.class.getSimpleName() + " e", Policy.class);
        return query.getResultList();
    }

    public <T extends Policy> T save(T policy) {
        return (T)((Policy)this.entityManager().merge(policy));
    }

    public <T extends Policy> void delete(T policy) {
        this.realmDAO.findByPolicy(policy).forEach(realm -> {
            if (policy instanceof AccountPolicy) {
                realm.setAccountPolicy(null);
            } else if (policy instanceof PasswordPolicy) {
                realm.setPasswordPolicy(null);
            }
        });
        this.resourceDAO.findByPolicy(policy).forEach(resource -> {
            if (policy instanceof AccountPolicy) {
                resource.setAccountPolicy(null);
            } else if (policy instanceof PasswordPolicy) {
                resource.setPasswordPolicy(null);
            } else if (policy instanceof PropagationPolicy) {
                resource.setPropagationPolicy(null);
            } else if (policy instanceof PullPolicy) {
                resource.setPullPolicy(null);
            } else if (policy instanceof PushPolicy) {
                resource.setPushPolicy(null);
            }
        });
        this.entityManager().remove(policy);
    }
}

