/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.entity.Delegation;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPADelegation;
import org.springframework.stereotype.Repository;

@Repository
public class JPADelegationDAO
extends AbstractDAO<Delegation>
implements DelegationDAO {
    public Delegation find(String key) {
        return (Delegation)this.entityManager().find(JPADelegation.class, (Object)key);
    }

    public Optional<String> findValidFor(String delegating, String delegated) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPADelegation.class.getSimpleName() + " e WHERE e.delegating.id=:delegating AND e.delegated.id=:delegated AND e.start <= :now AND (e.end IS NULL OR e.end >= :now)", Delegation.class);
        query.setParameter("delegating", (Object)delegating);
        query.setParameter("delegated", (Object)delegated);
        query.setParameter("now", (Object)new Date());
        query.setMaxResults(1);
        List raw = query.getResultList();
        return raw.isEmpty() ? Optional.empty() : Optional.of(((Delegation)raw.get(0)).getKey());
    }

    public List<String> findValidDelegating(String delegated) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPADelegation.class.getSimpleName() + " e WHERE e.delegated.id=:delegated AND e.start <= :now AND (e.end IS NULL OR e.end >= :now)", Delegation.class);
        query.setParameter("delegated", (Object)delegated);
        query.setParameter("now", (Object)new Date());
        return query.getResultList().stream().map(delegation -> delegation.getDelegating().getUsername()).collect(Collectors.toList());
    }

    public List<Delegation> findByDelegating(User user) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPADelegation.class.getSimpleName() + " e WHERE e.delegating=:user", Delegation.class);
        query.setParameter("user", (Object)user);
        return query.getResultList();
    }

    public List<Delegation> findByDelegated(User user) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPADelegation.class.getSimpleName() + " e WHERE e.delegated=:user", Delegation.class);
        query.setParameter("user", (Object)user);
        return query.getResultList();
    }

    public List<Delegation> findByRole(Role role) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPADelegation.class.getSimpleName() + " e WHERE :role MEMBER OF e.roles", Delegation.class);
        query.setParameter("role", (Object)role);
        return query.getResultList();
    }

    public List<Delegation> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPADelegation.class.getSimpleName() + " e ", Delegation.class);
        return query.getResultList();
    }

    public Delegation save(Delegation delegation) {
        return (Delegation)this.entityManager().merge((Object)delegation);
    }

    public void delete(String key) {
        Delegation delegation = this.find(key);
        if (delegation == null) {
            return;
        }
        this.entityManager().remove((Object)delegation);
    }
}

