/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.syncope.core.persistence.api.dao.DAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;

@Configurable
public abstract class AbstractDAO<E extends Entity>
implements DAO<E> {
    protected static final Logger LOG = LoggerFactory.getLogger(DAO.class);

    protected EntityManagerFactory entityManagerFactory() {
        return EntityManagerFactoryUtils.findEntityManagerFactory((ListableBeanFactory)ApplicationContextProvider.getBeanFactory(), (String)AuthContextUtils.getDomain());
    }

    protected EntityManager entityManager() {
        return Optional.ofNullable(EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)this.entityManagerFactory())).orElseThrow(() -> new IllegalStateException("Could not find EntityManager for domain " + AuthContextUtils.getDomain()));
    }

    public void refresh(E entity) {
        this.entityManager().refresh(entity);
    }

    public void detach(E entity) {
        this.entityManager().detach(entity);
    }

    public void clear() {
        this.entityManager().clear();
    }
}

