/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.PathParam;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ItemContainerTO;
import org.apache.syncope.common.lib.to.ItemTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.SAML2BindingType;

@XmlRootElement(name="saml2idp")
@XmlType
public class SAML2IdPTO
implements EntityTO,
ItemContainerTO {
    private static final long serialVersionUID = 4426527052873779881L;
    private String key;
    private String entityID;
    private String name;
    private String metadata;
    private boolean createUnmatching;
    private boolean updateMatching;
    private boolean selfRegUnmatching;
    private boolean useDeflateEncoding;
    private boolean supportUnsolicited;
    private SAML2BindingType bindingType;
    private boolean logoutSupported;
    private UserTO userTemplate;
    private final List<ItemTO> items = new ArrayList<ItemTO>();
    private final List<String> actionsClassNames = new ArrayList<String>();
    private String requestedAuthnContextProviderClassName;

    public String getKey() {
        return this.key;
    }

    @PathParam(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public String getEntityID() {
        return this.entityID;
    }

    public void setEntityID(String entityID) {
        this.entityID = entityID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public boolean isCreateUnmatching() {
        return this.createUnmatching;
    }

    public void setCreateUnmatching(boolean createUnmatching) {
        this.createUnmatching = createUnmatching;
    }

    public boolean isSelfRegUnmatching() {
        return this.selfRegUnmatching;
    }

    public void setSelfRegUnmatching(boolean selfRegUnmatching) {
        this.selfRegUnmatching = selfRegUnmatching;
    }

    public boolean isUpdateMatching() {
        return this.updateMatching;
    }

    public void setUpdateMatching(boolean updateMatching) {
        this.updateMatching = updateMatching;
    }

    public boolean isUseDeflateEncoding() {
        return this.useDeflateEncoding;
    }

    public void setUseDeflateEncoding(boolean useDeflateEncoding) {
        this.useDeflateEncoding = useDeflateEncoding;
    }

    public boolean isSupportUnsolicited() {
        return this.supportUnsolicited;
    }

    public void setSupportUnsolicited(boolean supportUnsolicited) {
        this.supportUnsolicited = supportUnsolicited;
    }

    public SAML2BindingType getBindingType() {
        return this.bindingType;
    }

    public void setBindingType(SAML2BindingType bindingType) {
        this.bindingType = bindingType;
    }

    public boolean isLogoutSupported() {
        return this.logoutSupported;
    }

    public void setLogoutSupported(boolean logoutSupported) {
        this.logoutSupported = logoutSupported;
    }

    public UserTO getUserTemplate() {
        return this.userTemplate;
    }

    public void setUserTemplate(UserTO userTemplate) {
        this.userTemplate = userTemplate;
    }

    public ItemTO getConnObjectKeyItem() {
        return this.getItems().stream().filter(item -> item.isConnObjectKey()).findFirst().orElse(null);
    }

    protected boolean addConnObjectKeyItem(ItemTO connObjectItem) {
        connObjectItem.setMandatoryCondition("true");
        connObjectItem.setConnObjectKey(true);
        return this.add(connObjectItem);
    }

    public boolean setConnObjectKeyItem(ItemTO connObjectKeyItem) {
        return connObjectKeyItem == null ? this.remove(this.getConnObjectKeyItem()) : this.addConnObjectKeyItem(connObjectKeyItem);
    }

    @XmlElementWrapper(name="items")
    @XmlElement(name="item")
    @JsonProperty(value="items")
    public List<ItemTO> getItems() {
        return this.items;
    }

    public boolean add(ItemTO item) {
        return item == null ? false : this.items.contains(item) || this.items.add(item);
    }

    public boolean remove(ItemTO item) {
        return this.items.remove(item);
    }

    @XmlElementWrapper(name="actionsClassNames")
    @XmlElement(name="actionsClassNames")
    @JsonProperty(value="actions")
    public List<String> getActionsClassNames() {
        return this.actionsClassNames;
    }

    public String getRequestedAuthnContextProviderClassName() {
        return this.requestedAuthnContextProviderClassName;
    }

    public void setRequestedAuthnContextProviderClassName(String requestedAuthnContextProviderClassName) {
        this.requestedAuthnContextProviderClassName = requestedAuthnContextProviderClassName;
    }
}

