/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.okta.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public class OktaUtils {
    private static final Log LOG = Log.getLog(OktaUtils.class);
    public static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");

    public static void handleGeneralError(String message) {
        LOG.error("General error : {0}", new Object[]{message});
        throw new ConnectorException(message);
    }

    public static void handleGeneralError(String message, Exception ex) {
        LOG.error((Throwable)ex, message, new Object[0]);
        throw new ConnectorException(message, (Throwable)ex);
    }

    public static void wrapGeneralError(String message, Exception ex) {
        LOG.error((Throwable)ex, message, new Object[0]);
        throw ConnectorException.wrap((Throwable)ex);
    }

    public static String buildSearchQuery(String attributeName, String attributeValue) {
        StringBuilder query = new StringBuilder("profile." + attributeName);
        query.append(" eq ");
        query.append("\"");
        query.append(attributeValue);
        query.append("\"");
        return query.toString();
    }

    public static Date convertToDate(long source) {
        Calendar cal = Calendar.getInstance(UTC_TIMEZONE);
        cal.setTimeInMillis(source);
        return cal.getTime();
    }
}

