/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.okta.utils;

import com.okta.sdk.client.Client;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserProfile;
import com.okta.sdk.resource.user.UserStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.Uid;

public final class OktaAttribute {
    private static final Log LOG = Log.getLog(OktaAttribute.class);
    public static final String ID = "id";
    public static final String STATUS = "status";
    public static final String SCHEMA_PROPERTIES = "properties";
    public static final String EMAIL = "email";
    public static final String LOGIN = "login";
    public static final String SECOND_EMAIL = "secondEmail";
    public static final String LASTNAME = "lastName";
    public static final String FIRSTNAME = "firstName";
    public static final String MOBILEPHONE = "mobilePhone";
    public static final String OKTA_GROUPS = "oktaGroups";
    public static final String NAME = "name";
    public static final String LABEL = "label";
    public static final String DESCRIPTION = "description";
    public static final String LASTUPDATED = "lastUpdated";
    public static final String OKTA_SECURITY_QUESTION = "oktaSecurityQuestion";
    public static final String OKTA_SECURITY_ANSWER = "oktaSecurityAnswer";
    public static final List<String> BASIC_PROFILE_ATTRIBUTES = new ArrayList<String>(){
        private static final long serialVersionUID = 5636572627689425575L;
        {
            this.add(OktaAttribute.EMAIL);
            this.add(OktaAttribute.LOGIN);
            this.add(OktaAttribute.SECOND_EMAIL);
            this.add(OktaAttribute.LASTNAME);
            this.add(OktaAttribute.FIRSTNAME);
            this.add(OktaAttribute.MOBILEPHONE);
        }
    };

    public static Class<?> getType(String type) {
        if (StringUtil.isBlank((String)type)) {
            return String.class;
        }
        Class typeClass = String.class;
        switch (type) {
            case "String": {
                typeClass = String.class;
                break;
            }
            case "Boolean": {
                typeClass = Boolean.class;
                break;
            }
            case "Integer": {
                typeClass = Integer.class;
                break;
            }
        }
        return typeClass;
    }

    public static Set<Attribute> buildUserAttributes(Client client, User user, Schema schema, Set<String> attributesToGet) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        ObjectClassInfo objectClassInfo = schema.findObjectClassInfo(ObjectClass.ACCOUNT_NAME);
        UserProfile userProfile = user.getProfile();
        attributesToGet.stream().forEach(attributeToGetName -> {
            if (Name.NAME.equals(attributeToGetName) || Uid.NAME.equals(attributeToGetName) || ID.equals(attributeToGetName)) {
                attributes.add(AttributeBuilder.build((String)attributeToGetName, (Object[])new Object[]{user.getId()}));
            } else if (STATUS.equals(attributeToGetName)) {
                attributes.add(OktaAttribute.buildAttribute(user.getStatus().toString(), attributeToGetName, String.class).build());
            } else if (OperationalAttributes.ENABLE_NAME.equals(attributeToGetName)) {
                attributes.add(OktaAttribute.buildAttribute(user.getStatus().equals((Object)UserStatus.ACTIVE), attributeToGetName, Boolean.class).build());
            } else if (OKTA_GROUPS.equals(attributeToGetName)) {
                try {
                    List assignedGroups = user.listGroups().stream().map(item -> item.getId()).collect(Collectors.toList());
                    attributes.add(OktaAttribute.buildAttribute(assignedGroups, attributeToGetName, Set.class).build());
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex, "Could not list groups for User {0}", new Object[]{user.getId()});
                }
            } else if (LASTUPDATED.equals(attributeToGetName)) {
                attributes.add(OktaAttribute.buildAttribute(user.getLastUpdated() != null ? user.getLastUpdated().getTime() : 0L, attributeToGetName, Long.class).build());
            } else {
                objectClassInfo.getAttributeInfo().stream().filter(attr -> attr.getName().equals(attributeToGetName)).findFirst().ifPresent(attributeInfo -> attributes.add(OktaAttribute.buildAttribute(userProfile.get(attributeToGetName), attributeToGetName, attributeInfo.getType()).build()));
            }
        });
        return attributes;
    }

    public static Set<Attribute> buildExtResourceAttributes(Client client, ExtensibleResource resource, Schema schema, Set<String> attributesToGet, String objName) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        ObjectClassInfo objectClassInfo = schema.findObjectClassInfo(objName);
        attributesToGet.stream().forEach(attributeToGetName -> {
            if (Name.NAME.equals(attributeToGetName) || Uid.NAME.equals(attributeToGetName) || ID.equals(attributeToGetName)) {
                attributes.add(AttributeBuilder.build((String)attributeToGetName, (Object[])new Object[]{resource.getString(ID)}));
            } else if (STATUS.equals(attributeToGetName)) {
                AttributeBuilder attributeBuilder = new AttributeBuilder();
                attributeBuilder.setName(attributeToGetName);
                if (resource instanceof Application) {
                    attributeBuilder.addValue(new Object[]{((Application)resource).getStatus()});
                }
                attributes.add(attributeBuilder.build());
            } else if (OperationalAttributes.ENABLE_NAME.equals(attributeToGetName)) {
                AttributeBuilder attributeBuilder = new AttributeBuilder();
                attributeBuilder.setName(attributeToGetName);
                if (resource instanceof Application) {
                    attributeBuilder.addValue(new Object[]{((Application)resource).getStatus().equals((Object)Application.StatusEnum.ACTIVE)});
                }
                attributes.add(attributeBuilder.build());
            } else if (OperationalAttributes.ENABLE_NAME.equals(attributeToGetName) || STATUS.equals(attributeToGetName)) {
                AttributeBuilder attributeBuilder = new AttributeBuilder().setName(attributeToGetName);
                if (resource instanceof Application) {
                    attributeBuilder.addValue(new Object[]{((Application)resource).getStatus().equals((Object)Application.StatusEnum.ACTIVE)});
                }
                attributes.add(attributeBuilder.build());
            } else if (LASTUPDATED.equals(attributeToGetName)) {
                attributes.add(OktaAttribute.buildAttribute(resource.get((Object)LASTUPDATED) != null ? ((Date)resource.get((Object)LASTUPDATED)).getTime() : 0L, attributeToGetName, Long.class).build());
            } else {
                objectClassInfo.getAttributeInfo().stream().filter(attr -> attr.getName().equals(attributeToGetName)).findFirst().ifPresent(attributeInfo -> attributes.add(OktaAttribute.buildAttribute(resource instanceof Group ? ((Group)resource).getProfile().getString(attributeToGetName) : resource.getString(attributeToGetName), attributeToGetName, attributeInfo.getType()).build()));
            }
        });
        return attributes;
    }

    public static AttributeBuilder buildAttribute(Object value, String name, Class<?> clazz) {
        return OktaAttribute.buildAttribute(value, name, clazz, new AttributeBuilder());
    }

    public static AttributeBuilder buildAttribute(Object value, String name, Class<?> clazz, AttributeBuilder attributeBuilder) {
        if (value != null) {
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                attributeBuilder.addValue(new Object[]{Boolean.class.cast(value)});
            } else if (value instanceof List) {
                ArrayList list = new ArrayList((List)value);
                if (list.size() > 1) {
                    list.forEach(elem -> OktaAttribute.buildAttribute(elem, name, clazz, attributeBuilder));
                } else if (!list.isEmpty()) {
                    attributeBuilder.addValue(new Object[]{list.get(0).toString()});
                }
            } else {
                attributeBuilder.addValue(new Object[]{value.toString()});
            }
        }
        if (name != null) {
            attributeBuilder.setName(name);
        }
        return attributeBuilder;
    }

    public static String buildProfileAttrName(String name) {
        return "profile." + name;
    }
}

