/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleApplication;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.any.MergeLinkedAccountsWizardModel;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class MergeLinkedAccountsResourcesPanel
extends WizardStep
implements WizardModel.ICondition {
    private static final long serialVersionUID = 1221037007528732347L;
    private final MergeLinkedAccountsWizardModel wizardModel;

    public MergeLinkedAccountsResourcesPanel(MergeLinkedAccountsWizardModel wizardModel, PageReference pageReference) {
        this.setOutputMarkupId(true);
        this.wizardModel = wizardModel;
        this.add(new Component[]{new ResourceSelectionDirectoryPanel("resources", pageReference)});
    }

    public boolean evaluate() {
        return SyncopeConsoleApplication.get().getSecuritySettings().getAuthorizationStrategy().isActionAuthorized((Component)this, RENDER);
    }

    public String getTitle() {
        this.setSummaryModel((IModel)new StringResourceModel("mergeLinkedAccounts.searchResource.summary", (IModel)Model.of((Serializable)this.wizardModel.getMergingUser())));
        this.setTitleModel((IModel)new StringResourceModel("mergeLinkedAccounts.searchResource.title", (IModel)Model.of((Serializable)this.wizardModel.getMergingUser())));
        return super.getTitle();
    }

    private class ResourceSelectionDirectoryPanel
    extends DirectoryPanel<ResourceTO, ResourceTO, ResourcesDataProvider, ResourceRestClient> {
        private static final long serialVersionUID = 6005711052393825472L;

        ResourceSelectionDirectoryPanel(String id, PageReference pageReference) {
            super(id, pageReference, true);
            this.restClient = new ResourceRestClient();
            this.modal.size(Modal.Size.Large);
            this.setOutputMarkupId(true);
            this.disableCheckBoxes();
            this.initResultTable();
        }

        @Override
        protected ResourcesDataProvider dataProvider() {
            return new ResourcesDataProvider(this.rows);
        }

        @Override
        protected String paginatorRowsKey() {
            return "resources.paginator.rows";
        }

        @Override
        protected List<IColumn<ResourceTO, String>> getColumns() {
            ArrayList<IColumn<ResourceTO, String>> columns = new ArrayList<IColumn<ResourceTO, String>>();
            columns.add((IColumn<ResourceTO, String>)new PropertyColumn((IModel)new ResourceModel("resource"), (Object)"key", "key"));
            return columns;
        }

        @Override
        protected ActionsPanel<ResourceTO> getActions(IModel<ResourceTO> model) {
            ActionsPanel<ResourceTO> panel = super.getActions(model);
            panel.add(new ActionLink<ResourceTO>(){
                private static final long serialVersionUID = -7978723352517770644L;

                @Override
                public void onClick(AjaxRequestTarget target, ResourceTO resource) {
                    MergeLinkedAccountsWizardModel model = MergeLinkedAccountsResourcesPanel.this.wizardModel;
                    String connObjectKeyValue = ((ResourceRestClient)ResourceSelectionDirectoryPanel.this.restClient).getConnObjectKeyValue(resource.getKey(), model.getMergingUser().getType(), model.getMergingUser().getKey());
                    if (connObjectKeyValue != null) {
                        model.setResource(resource);
                        String tableId = MergeLinkedAccountsResourcesPanel.this.get("resources:container:content:searchContainer:resultTable:tablePanel:groupForm:checkgroup:dataTable").getMarkupId();
                        String js = "$('#" + tableId + "').removeClass('active');";
                        js = js + "$('#" + tableId + " tbody tr td div').filter(function() {return $(this).text() === \"" + resource.getKey() + "\";}).parent().parent().addClass('active');";
                        target.prependJavaScript((CharSequence)js);
                    } else {
                        ResourceSelectionDirectoryPanel.this.error((Serializable)((Object)"Unable to determine connector object key"));
                        ((BasePage)ResourceSelectionDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                }
            }, ActionLink.ActionType.SELECT, "RESOURCE_READ");
            return panel;
        }

        @Override
        protected Collection<ActionLink.ActionType> getBatches() {
            return Collections.emptyList();
        }

        protected final class ResourcesDataProvider
        extends DirectoryDataProvider<ResourceTO> {
            private static final long serialVersionUID = -185944053385660794L;
            private final SortableDataProviderComparator<ResourceTO> comparator;

            private ResourcesDataProvider(int paginatorRows) {
                super(paginatorRows);
                this.setSort("key", SortOrder.ASCENDING);
                this.comparator = new SortableDataProviderComparator<ResourceTO>(this);
            }

            public Iterator<ResourceTO> iterator(long first, long count) {
                List<ResourceTO> list = ((ResourceRestClient)ResourceSelectionDirectoryPanel.this.restClient).list();
                Collections.sort(list, this.comparator);
                return list.subList((int)first, (int)first + (int)count).iterator();
            }

            public long size() {
                return ((ResourceRestClient)ResourceSelectionDirectoryPanel.this.restClient).list().size();
            }

            public IModel<ResourceTO> model(ResourceTO object) {
                return new CompoundPropertyModel((Object)object);
            }
        }
    }
}

