/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.client.console.rest.ExecutionRestClient;
import org.apache.syncope.client.console.rest.TemplateRestClient;
import org.apache.syncope.client.lib.batch.BatchRequest;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.to.ReportTemplateTO;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.lib.types.ReportExecExportFormat;
import org.apache.syncope.common.lib.types.ReportTemplateFormat;
import org.apache.syncope.common.rest.api.batch.BatchRequestItem;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.apache.syncope.common.rest.api.beans.ExecQuery;
import org.apache.syncope.common.rest.api.beans.ExecuteQuery;
import org.apache.syncope.common.rest.api.service.ReportService;
import org.apache.syncope.common.rest.api.service.ReportTemplateService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public class ReportRestClient
extends BaseRestClient
implements ExecutionRestClient,
TemplateRestClient<ReportTemplateTO, ReportTemplateFormat> {
    private static final long serialVersionUID = 1644689667998953604L;

    public ReportTO read(String reportKey) {
        return ReportRestClient.getService(ReportService.class).read(reportKey);
    }

    public List<ReportTO> list() {
        return ReportRestClient.getService(ReportService.class).list();
    }

    public JobTO getJob(String key) {
        return ReportRestClient.getService(ReportService.class).getJob(key);
    }

    public List<JobTO> listJobs() {
        return ReportRestClient.getService(ReportService.class).listJobs();
    }

    public void actionJob(String refKey, JobAction jobAction) {
        ReportRestClient.getService(ReportService.class).actionJob(refKey, jobAction);
    }

    public void create(ReportTO reportTO) {
        ReportRestClient.getService(ReportService.class).create(reportTO);
    }

    public void update(ReportTO reportTO) {
        ReportRestClient.getService(ReportService.class).update(reportTO);
    }

    public void delete(String reportKey) {
        ReportRestClient.getService(ReportService.class).delete(reportKey);
    }

    @Override
    public void startExecution(String reportKey, Date start) {
        ReportRestClient.getService(ReportService.class).execute(new ExecuteQuery.Builder().key(reportKey).startAt(start).build());
    }

    @Override
    public void deleteExecution(String reportExecKey) {
        ReportRestClient.getService(ReportService.class).deleteExecution(reportExecKey);
    }

    @Override
    public List<ExecTO> listRecentExecutions(int max) {
        return ReportRestClient.getService(ReportService.class).listRecentExecutions(max);
    }

    public Response exportExecutionResult(String executionKey, ReportExecExportFormat fmt) {
        return ReportRestClient.getService(ReportService.class).exportExecutionResult(executionKey, fmt);
    }

    @Override
    public List<ExecTO> listExecutions(String taskKey, int page, int size, SortParam<String> sort) {
        return ReportRestClient.getService(ReportService.class).listExecutions((ExecQuery)((ExecQuery.Builder)((ExecQuery.Builder)((ExecQuery.Builder)new ExecQuery.Builder().key(taskKey).page(Integer.valueOf(page))).size(Integer.valueOf(size))).orderBy(ReportRestClient.toOrderBy(sort))).build()).getResult();
    }

    @Override
    public int countExecutions(String taskKey) {
        return ReportRestClient.getService(ReportService.class).listExecutions((ExecQuery)((ExecQuery.Builder)((ExecQuery.Builder)new ExecQuery.Builder().key(taskKey).page(Integer.valueOf(1))).size(Integer.valueOf(0))).build()).getTotalCount();
    }

    @Override
    public List<ReportTemplateTO> listTemplates() {
        return ReportRestClient.getService(ReportTemplateService.class).list();
    }

    @Override
    public void createTemplate(ReportTemplateTO reportTemplateTO) {
        ReportRestClient.getService(ReportTemplateService.class).create(reportTemplateTO);
    }

    @Override
    public void deleteTemplate(String key) {
        ReportRestClient.getService(ReportTemplateService.class).delete(key);
    }

    @Override
    public ReportTemplateTO readTemplate(String key) {
        return ReportRestClient.getService(ReportTemplateService.class).read(key);
    }

    @Override
    public String readTemplateFormat(String key, ReportTemplateFormat format) {
        try {
            return IOUtils.toString((InputStream)((InputStream)InputStream.class.cast(ReportRestClient.getService(ReportTemplateService.class).getFormat(key, format).getEntity())), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOG.error("Error retrieving report template {} as {}", new Object[]{key, format, e});
            return "";
        }
    }

    @Override
    public void updateTemplateFormat(String key, String content, ReportTemplateFormat format) {
        ReportRestClient.getService(ReportTemplateService.class).setFormat(key, format, IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8));
    }

    @Override
    public Map<String, String> batch(BatchRequest batchRequest) {
        ArrayList batchRequestItems = new ArrayList(batchRequest.getItems());
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        try {
            List batchResponseItems = batchRequest.commit().getItems();
            for (int i = 0; i < batchResponseItems.size(); ++i) {
                String status = ReportRestClient.getStatus(((BatchResponseItem)batchResponseItems.get(i)).getStatus());
                if (((BatchRequestItem)batchRequestItems.get(i)).getRequestURI().contains("/execute")) {
                    result.put(StringUtils.substringAfterLast((String)StringUtils.substringBefore((String)((BatchRequestItem)batchRequestItems.get(i)).getRequestURI(), (String)"/execute"), (String)"/"), status);
                    continue;
                }
                result.put(StringUtils.substringAfterLast((String)((BatchRequestItem)batchRequestItems.get(i)).getRequestURI(), (String)"/"), status);
            }
        }
        catch (IOException e) {
            LOG.error("While processing Batch response", (Throwable)e);
        }
        return result;
    }
}

