/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.search;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.cxf.jaxrs.ext.search.visitor.AbstractSearchConditionVisitor;
import org.apache.syncope.common.lib.search.SpecialAttr;
import org.apache.syncope.common.lib.search.SyncopeFiqlSearchCondition;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;

public class FilterVisitor
extends AbstractSearchConditionVisitor<SearchBean, Filter> {
    private Filter filter;
    private final Set<String> attrs = new HashSet<String>();

    public FilterVisitor() {
        super(null);
    }

    private Filter visitPrimitive(SearchCondition<SearchBean> sc) {
        Filter leaf;
        String name = this.getRealPropertyName(sc.getStatement().getProperty());
        Optional specialAttrName = SpecialAttr.fromString((String)name);
        String value = null;
        try {
            value = SearchUtils.toSqlWildcardString((String)URLDecoder.decode(sc.getStatement().getValue().toString(), StandardCharsets.UTF_8.name()), (boolean)false).replaceAll("\\\\_", "_");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("While decoding " + sc.getStatement().getValue(), e);
        }
        Optional specialAttrValue = SpecialAttr.fromString((String)value);
        ConditionType ct = sc.getConditionType();
        if (sc instanceof SyncopeFiqlSearchCondition && sc.getConditionType() == ConditionType.CUSTOM) {
            SyncopeFiqlSearchCondition sfsc = (SyncopeFiqlSearchCondition)sc;
            switch (sfsc.getOperator()) {
                case "=~": {
                    ct = ConditionType.EQUALS;
                    break;
                }
                case "!~": {
                    ct = ConditionType.NOT_EQUALS;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Condition type %s is not supported", sfsc.getOperator()));
                }
            }
        }
        Attribute attr = AttributeBuilder.build((String)name, (Object[])new Object[]{value});
        this.attrs.add(name);
        switch (ct) {
            case EQUALS: 
            case NOT_EQUALS: {
                if (!specialAttrName.isPresent()) {
                    if (specialAttrValue.isPresent() && specialAttrValue.get() == SpecialAttr.NULL) {
                        Filter empty = FilterBuilder.startsWith((Attribute)AttributeBuilder.build((String)name, (Object[])new Object[]{""}));
                        if (ct == ConditionType.NOT_EQUALS) {
                            leaf = empty;
                            break;
                        }
                        leaf = FilterBuilder.not((Filter)empty);
                        this.attrs.remove(name);
                        break;
                    }
                    if (value.indexOf(37) == -1) {
                        leaf = sc.getConditionType() == ConditionType.CUSTOM ? FilterBuilder.equalsIgnoreCase((Attribute)attr) : FilterBuilder.equalTo((Attribute)attr);
                    } else if (sc.getConditionType() != ConditionType.CUSTOM && value.startsWith("%")) {
                        leaf = FilterBuilder.endsWith((Attribute)AttributeBuilder.build((String)name, (Object[])new Object[]{value.substring(1)}));
                    } else if (sc.getConditionType() != ConditionType.CUSTOM && value.endsWith("%")) {
                        leaf = FilterBuilder.startsWith((Attribute)AttributeBuilder.build((String)name, (Object[])new Object[]{value.substring(0, value.length() - 1)}));
                    } else {
                        throw new IllegalArgumentException(String.format("Unsupported search value %s", value));
                    }
                    if (ct != ConditionType.NOT_EQUALS) break;
                    leaf = FilterBuilder.not((Filter)leaf);
                    break;
                }
                throw new IllegalArgumentException(String.format("Special attr name %s is not supported", specialAttrName));
            }
            case GREATER_OR_EQUALS: {
                leaf = FilterBuilder.greaterThanOrEqualTo((Attribute)attr);
                break;
            }
            case GREATER_THAN: {
                leaf = FilterBuilder.greaterThan((Attribute)attr);
                break;
            }
            case LESS_OR_EQUALS: {
                leaf = FilterBuilder.lessThanOrEqualTo((Attribute)attr);
                break;
            }
            case LESS_THAN: {
                leaf = FilterBuilder.lessThan((Attribute)attr);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Condition type %s is not supported", ct.name()));
            }
        }
        return leaf;
    }

    private Filter visitCompount(SearchCondition<SearchBean> sc) {
        Filter compound;
        ArrayList searchConds = new ArrayList();
        sc.getSearchConditions().forEach(searchCond -> searchConds.add(searchCond.getStatement() == null ? this.visitCompount((SearchCondition<SearchBean>)searchCond) : this.visitPrimitive((SearchCondition<SearchBean>)searchCond)));
        switch (sc.getConditionType()) {
            case AND: {
                compound = FilterBuilder.and(searchConds);
                break;
            }
            case OR: {
                compound = FilterBuilder.or(searchConds);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Condition type %s is not supported", sc.getConditionType().name()));
            }
        }
        return compound;
    }

    public void visit(SearchCondition<SearchBean> sc) {
        this.filter = sc.getStatement() == null ? this.visitCompount(sc) : this.visitPrimitive(sc);
    }

    public Filter getQuery() {
        return this.filter;
    }

    public Set<String> getAttrs() {
        return this.attrs;
    }
}

