/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.dao.search;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;

public class SearchCond
extends AbstractSearchCond {
    private static final long serialVersionUID = 661560782247499526L;
    private Type type;
    private AbstractSearchCond leaf;
    private SearchCond left;
    private SearchCond right;

    public static SearchCond getLeaf(AbstractSearchCond leaf) {
        SearchCond cond;
        if (leaf instanceof SearchCond) {
            cond = (SearchCond)leaf;
        } else {
            cond = new SearchCond();
            cond.leaf = leaf;
        }
        cond.type = Type.LEAF;
        return cond;
    }

    public static SearchCond getNotLeaf(AbstractSearchCond leaf) {
        SearchCond cond = SearchCond.getLeaf(leaf);
        cond.type = Type.NOT_LEAF;
        return cond;
    }

    public static SearchCond getAnd(SearchCond left, SearchCond right) {
        SearchCond cond = new SearchCond();
        cond.type = Type.AND;
        cond.left = left;
        cond.right = right;
        return cond;
    }

    public static SearchCond getAnd(List<SearchCond> conditions) {
        if (conditions.size() == 1) {
            return conditions.get(0);
        }
        if (conditions.size() > 2) {
            SearchCond removed = conditions.remove(0);
            return SearchCond.getAnd(removed, SearchCond.getAnd(conditions));
        }
        return SearchCond.getAnd(conditions.get(0), conditions.get(1));
    }

    public static SearchCond getOr(SearchCond left, SearchCond right) {
        SearchCond cond = new SearchCond();
        cond.type = Type.OR;
        cond.left = left;
        cond.right = right;
        return cond;
    }

    public static SearchCond getOr(List<SearchCond> conditions) {
        if (conditions.size() == 1) {
            return conditions.get(0);
        }
        if (conditions.size() > 2) {
            SearchCond removed = conditions.remove(0);
            return SearchCond.getOr(removed, SearchCond.getOr(conditions));
        }
        return SearchCond.getOr(conditions.get(0), conditions.get(1));
    }

    public Optional<AnyTypeCond> getAnyTypeCond() {
        return Optional.ofNullable(this.leaf instanceof AnyTypeCond ? (AnyTypeCond)this.leaf : null);
    }

    public String hasAnyTypeCond() {
        String anyTypeName = null;
        if (this.type == null) {
            return anyTypeName;
        }
        switch (this.type) {
            case LEAF: 
            case NOT_LEAF: {
                if (!(this.leaf instanceof AnyTypeCond)) break;
                anyTypeName = ((AnyTypeCond)this.leaf).getAnyTypeKey();
                break;
            }
            case AND: 
            case OR: {
                if (this.left != null) {
                    anyTypeName = this.left.hasAnyTypeCond();
                }
                if (anyTypeName != null || this.right == null) break;
                anyTypeName = this.right.hasAnyTypeCond();
                break;
            }
        }
        return anyTypeName;
    }

    public <T extends AbstractSearchCond> Optional<T> getLeaf(Class<T> clazz) {
        return Optional.ofNullable(clazz.isInstance(this.leaf) ? this.leaf : null);
    }

    public SearchCond getLeft() {
        return this.left;
    }

    public SearchCond getRight() {
        return this.right;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isValid() {
        boolean isValid = false;
        if (this.type == null) {
            return isValid;
        }
        switch (this.type) {
            case LEAF: 
            case NOT_LEAF: {
                isValid = this.leaf != null && this.leaf.isValid();
                break;
            }
            case AND: 
            case OR: {
                isValid = this.left != null && this.right != null && this.left.isValid() && this.right.isValid();
                break;
            }
        }
        return isValid;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.type).append((Object)this.leaf).append((Object)this.left).append((Object)this.right).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchCond other = (SearchCond)obj;
        return new EqualsBuilder().append((Object)this.type, (Object)other.type).append((Object)this.leaf, (Object)other.leaf).append((Object)this.left, (Object)other.left).append((Object)this.right, (Object)other.right).build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.type).append((Object)this.leaf).append((Object)this.left).append((Object)this.right).build();
    }

    public static enum Type {
        LEAF,
        NOT_LEAF,
        AND,
        OR;

    }
}

