/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.core.persistence.api.entity.OIDCProvider;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.OIDCProviderCheck;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;

public class OIDCProviderValidator
extends AbstractValidator<OIDCProviderCheck, OIDCProvider> {
    public boolean isValid(OIDCProvider oidcProvider, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (this.isHtml(oidcProvider.getKey())) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidKey, oidcProvider.getKey())).addPropertyNode("key").addConstraintViolation();
            return false;
        }
        if (oidcProvider.isSelfRegUnmatching() && oidcProvider.isCreateUnmatching()) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.Standard, "Either selfRegUnmatching or createUnmatching, not both")).addPropertyNode("selfRegUnmatching").addPropertyNode("createUnmatching").addConstraintViolation();
            return false;
        }
        long connObjectKeys = oidcProvider.getItems().stream().filter(Item::isConnObjectKey).count();
        if (!oidcProvider.getItems().isEmpty() && connObjectKeys != 1L) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidMapping, "Single ConnObjectKey mapping is required")).addPropertyNode("connObjectKey.size").addConstraintViolation();
            return false;
        }
        boolean[] isValid = new boolean[]{true};
        long passwords = oidcProvider.getItems().stream().filter(Item::isPassword).count();
        if (passwords > 0L) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidMapping, "No password mapping is allowed")).addPropertyNode("password.size").addConstraintViolation();
            isValid[0] = false;
        }
        oidcProvider.getItems().forEach(item -> item.getTransformers().stream().filter(transformer -> transformer.getEngine() == ImplementationEngine.JAVA).forEach(transformer -> {
            Class<?> actionsClass = null;
            boolean isAssignable = false;
            try {
                actionsClass = Class.forName(transformer.getBody());
                isAssignable = ItemTransformer.class.isAssignableFrom(actionsClass);
            }
            catch (Exception e) {
                LOG.error("Invalid ItemTransformer specified: {}", (Object)transformer.getBody(), (Object)e);
            }
            if (actionsClass == null || !isAssignable) {
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidMapping, "Invalid item trasformer class name")).addPropertyNode("itemTransformers").addConstraintViolation();
                isValid[0] = false;
            }
        }));
        return isValid[0];
    }
}

