/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.services.admin.directory.Directory;
import com.google.api.services.admin.directory.model.Group;
import com.google.api.services.admin.directory.model.Member;
import java.io.IOException;
import net.tirasa.connid.bundles.googleapps.GoogleAppsConnector;
import net.tirasa.connid.bundles.googleapps.GoogleAppsUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.PredefinedAttributeInfos;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.AndFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsAllValuesFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsIgnoreCaseFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterVisitor;
import org.identityconnectors.framework.common.objects.filter.GreaterThanFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.NotFilter;
import org.identityconnectors.framework.common.objects.filter.OrFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;

public class GroupHandler
implements FilterVisitor<Void, Directory.Groups.List> {
    private static final Log LOG = Log.getLog(GroupHandler.class);

    public Void visitAndFilter(Directory.Groups.List list, AndFilter andFilter) {
        throw this.getException();
    }

    public Void visitContainsFilter(Directory.Groups.List list, ContainsFilter containsFilter) {
        if (!containsFilter.getAttribute().is("__MEMBERS__")) {
            throw this.getException();
        }
        list.setUserKey(containsFilter.getValue());
        return null;
    }

    public Void visitContainsAllValuesFilter(Directory.Groups.List list, ContainsAllValuesFilter containsAllValuesFilter) {
        throw this.getException();
    }

    protected RuntimeException getException() {
        return new UnsupportedOperationException("Only EqualsFilter(['domain','customer','userKey']) and ContainsFilter('members') are supported");
    }

    public Void visitEqualsFilter(Directory.Groups.List list, EqualsFilter equalsFilter) {
        if (equalsFilter.getAttribute().is("customer")) {
            if (null != list.getDomain() || null != list.getUserKey()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setCustomer(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else if (equalsFilter.getAttribute().is("domain")) {
            if (null != list.getCustomer() || null != list.getUserKey()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setDomain(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else if (equalsFilter.getAttribute().is("userKey")) {
            if (null != list.getDomain() || null != list.getCustomer()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setUserKey(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else {
            throw this.getException();
        }
        return null;
    }

    public Void visitEqualsIgnoreCaseFilter(Directory.Groups.List list, EqualsIgnoreCaseFilter equalsFilter) {
        if (equalsFilter.getAttribute().is("customer")) {
            if (null != list.getDomain() || null != list.getUserKey()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setCustomer(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else if (equalsFilter.getAttribute().is("domain")) {
            if (null != list.getCustomer() || null != list.getUserKey()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setDomain(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else if (equalsFilter.getAttribute().is("userKey")) {
            if (null != list.getDomain() || null != list.getCustomer()) {
                throw new InvalidAttributeValueException("The 'customer', 'domain' and 'userKey' can not be in the same query");
            }
            list.setUserKey(AttributeUtil.getStringValue((Attribute)equalsFilter.getAttribute()));
        } else {
            throw this.getException();
        }
        return null;
    }

    public Void visitExtendedFilter(Directory.Groups.List list, Filter filter) {
        throw this.getException();
    }

    public Void visitGreaterThanFilter(Directory.Groups.List list, GreaterThanFilter greaterThanFilter) {
        throw this.getException();
    }

    public Void visitGreaterThanOrEqualFilter(Directory.Groups.List list, GreaterThanOrEqualFilter greaterThanOrEqualFilter) {
        throw this.getException();
    }

    public Void visitLessThanFilter(Directory.Groups.List list, LessThanFilter lessThanFilter) {
        throw this.getException();
    }

    public Void visitLessThanOrEqualFilter(Directory.Groups.List list, LessThanOrEqualFilter lessThanOrEqualFilter) {
        throw this.getException();
    }

    public Void visitNotFilter(Directory.Groups.List list, NotFilter notFilter) {
        throw this.getException();
    }

    public Void visitOrFilter(Directory.Groups.List list, OrFilter orFilter) {
        throw this.getException();
    }

    public Void visitStartsWithFilter(Directory.Groups.List list, StartsWithFilter startsWithFilter) {
        throw this.getException();
    }

    public Void visitEndsWithFilter(Directory.Groups.List list, EndsWithFilter endsWithFilter) {
        throw this.getException();
    }

    public static ObjectClassInfo getGroupClassInfo() {
        ObjectClassInfoBuilder builder = new ObjectClassInfoBuilder();
        builder.setType(ObjectClass.GROUP_NAME);
        builder.addAttributeInfo(Name.INFO);
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"name"));
        builder.addAttributeInfo(PredefinedAttributeInfos.DESCRIPTION);
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"adminCreated", Boolean.TYPE).setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"aliases").setUpdateable(false).setCreateable(false).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"nonEditableAliases").setUpdateable(false).setCreateable(false).setMultiValued(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"directMembersCount", Long.TYPE).setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"__MEMBERS__").setMultiValued(true).setReturnedByDefault(false).build());
        return builder.build();
    }

    public static ObjectClassInfo getMemberClassInfo() {
        ObjectClassInfoBuilder builder = new ObjectClassInfoBuilder();
        builder.setType(GoogleAppsConnector.MEMBER.getObjectClassValue());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)Name.NAME).setUpdateable(false).setCreateable(false).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"groupKey").setUpdateable(false).setRequired(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"email").setUpdateable(false).setRequired(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"role"));
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"type").setUpdateable(false).setCreateable(false).build());
        return builder.build();
    }

    public static Directory.Groups.Insert createGroup(Directory.Groups groups, AttributesAccessor attributes) {
        Group group = new Group();
        group.setEmail(GoogleAppsUtil.getName(attributes.getName()));
        group.setDescription(attributes.findString(PredefinedAttributes.DESCRIPTION));
        group.setName(attributes.findString("name"));
        try {
            return groups.insert(group).setFields("id,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Groups#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Groups.Patch updateGroup(Directory.Groups groups, String groupKey, AttributesAccessor attributes) {
        String stringValue;
        Attribute name;
        String stringValue2;
        Attribute description;
        String stringValue3;
        Group group = null;
        Name email = attributes.getName();
        if (email != null && null != (stringValue3 = GoogleAppsUtil.getStringValueWithDefault((Attribute)email, null))) {
            if (StringUtil.isBlank((String)stringValue3)) {
                throw new InvalidAttributeValueException("Invalid attribute '__NAME__'. The group's email address. Can not be blank when updating a group.");
            }
            group = new Group();
            group.setEmail(stringValue3);
        }
        if (null != (description = attributes.find(PredefinedAttributes.DESCRIPTION)) && null != (stringValue2 = GoogleAppsUtil.getStringValueWithDefault(description, null))) {
            if (null == group) {
                group = new Group();
            }
            group.setDescription(stringValue2);
        }
        if (null != (name = attributes.find("name")) && null != (stringValue = GoogleAppsUtil.getStringValueWithDefault(name, null))) {
            if (null == group) {
                group = new Group();
            }
            group.setName(stringValue);
        }
        if (null == group) {
            return null;
        }
        try {
            return groups.patch(groupKey, group).setFields("id,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Groups#Patch", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Members.Insert createMember(Directory.Members service, AttributesAccessor attributes) {
        String groupKey = attributes.findString("groupKey");
        if (StringUtil.isBlank((String)groupKey)) {
            throw new InvalidAttributeValueException("Missing required attribute 'groupKey'. Identifies the group in the API request. Required when creating a Member.");
        }
        String memberKey = attributes.findString("email");
        if (StringUtil.isBlank((String)memberKey)) {
            throw new InvalidAttributeValueException("Missing required attribute 'memberKey'. Identifies the group member in the API request. Required when creating a Member.");
        }
        String role = attributes.findString("role");
        return GroupHandler.createMember(service, groupKey, memberKey, role);
    }

    public static Directory.Members.Insert createMember(Directory.Members service, String groupKey, String memberKey, String role) {
        Member content = new Member();
        content.setEmail(memberKey);
        if (StringUtil.isBlank((String)role)) {
            content.setRole("MEMBER");
        } else {
            content.setRole(role);
        }
        try {
            return service.insert(groupKey, content).setFields("email,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Members#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Members.Patch updateMembers(Directory.Members service, String groupKey, String memberKey, String role) {
        Member content = new Member();
        content.setEmail(memberKey);
        if (StringUtil.isBlank((String)role)) {
            content.setRole("MEMBER");
        } else {
            content.setRole(role);
        }
        try {
            return service.patch(groupKey, memberKey, content).setFields("email,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Members#Update", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Members.Delete deleteMembers(Directory.Members service, String groupKey, String memberKey) {
        try {
            return service.delete(groupKey, memberKey);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Members#Delete", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static ConnectorObject fromMember(String groupKey, Member content) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(GoogleAppsConnector.MEMBER);
        Uid uid = GroupHandler.generateMemberId(groupKey, content);
        builder.setUid(uid);
        builder.setName(uid.getUidValue());
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"groupKey", (Object[])new Object[]{content.getId()})});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"email", (Object[])new Object[]{content.getEmail()})});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"role", (Object[])new Object[]{content.getRole()})});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"type", (Object[])new Object[]{content.getType()})});
        return builder.build();
    }

    public static Uid generateMemberId(String groupKey, Member content) {
        String memberName = groupKey + '/' + content.getEmail();
        Uid uid = null != content.getEtag() ? new Uid(memberName, content.getEtag()) : new Uid(memberName);
        return uid;
    }
}

