/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.syncope.core.persistence.api.SyncopeLoader;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.stereotype.Component;

@Component
public class LogicStartStop
implements BeanFactoryAware,
InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(LogicStartStop.class);
    private DefaultListableBeanFactory beanFactory;
    private final List<SyncopeLoader> loaders = new ArrayList<SyncopeLoader>();

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = (DefaultListableBeanFactory)beanFactory;
    }

    private void execute(Consumer<SyncopeLoader> action) {
        this.loaders.forEach(loader -> {
            LOG.debug("Invoking {} with priority {}", (Object)AopUtils.getTargetClass((Object)loader).getName(), (Object)loader.getPriority());
            action.accept((SyncopeLoader)loader);
        });
    }

    public void afterPropertiesSet() throws Exception {
        ApplicationContextProvider.setBeanFactory((DefaultListableBeanFactory)this.beanFactory);
        this.loaders.addAll(this.beanFactory.getBeansOfType(SyncopeLoader.class).values().stream().sorted(Comparator.comparing(SyncopeLoader::getPriority)).collect(Collectors.toList()));
        LOG.debug("Starting init...");
        this.execute(SyncopeLoader::load);
        LOG.debug("Init completed");
    }

    public void destroy() throws Exception {
        Collections.reverse(this.loaders);
        LOG.debug("Starting dispose...");
        this.execute(SyncopeLoader::unload);
        LOG.debug("Dispose completed");
    }
}

