/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure.utils;

import java.util.List;
import net.tirasa.connid.bundles.azure.utils.AzureFilterOp;
import org.identityconnectors.framework.common.objects.Attribute;

public class AzureFilter {
    private final AzureFilterOp filterOp;
    private final Attribute attribute;
    private final String value;
    private final boolean quote;
    private final List<AzureFilter> filters;

    public AzureFilter(AzureFilterOp filterOp, Attribute attribute, String value, boolean quote, List<AzureFilter> filters) {
        this.filterOp = filterOp;
        this.attribute = attribute;
        this.value = value;
        this.quote = quote;
        this.filters = filters;
    }

    public AzureFilterOp getFilterOp() {
        return this.filterOp;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isQuote() {
        return this.quote;
    }

    public List<AzureFilter> getFilters() {
        return this.filters;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public void toString(StringBuilder builder) {
        switch (this.filterOp) {
            case AND: 
            case OR: {
                for (int i = 0; i < this.filters.size(); ++i) {
                    if (i != 0) {
                        builder.append(' ');
                        builder.append((Object)this.filterOp);
                        builder.append(' ');
                    }
                    builder.append(this.filters.get(i));
                }
                break;
            }
            case EQUALS: 
            case CONTAINS: 
            case STARTS_WITH: 
            case GREATER_THAN: 
            case GREATER_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_OR_EQUAL: {
                builder.append(this.attribute);
                builder.append(' ');
                builder.append((Object)this.filterOp);
                builder.append(' ');
                if (this.quote) {
                    builder.append("\"");
                    builder.append(this.value);
                    builder.append("\"");
                    break;
                }
                builder.append(this.value);
                break;
            }
            case IS_PRESENT: {
                builder.append(this.attribute);
                builder.append(' ');
                builder.append((Object)this.filterOp);
            }
        }
    }
}

