/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.basic;

import org.apache.wicket.IGenericComponent;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Classes;

public class EnumLabel<T extends Enum<T>>
extends WebComponent
implements IGenericComponent<T, EnumLabel<T>> {
    private static final long serialVersionUID = 1L;

    public EnumLabel(String id) {
        super(id);
    }

    public EnumLabel(String id, T value) {
        this(id, new Model<T>(value));
    }

    public EnumLabel(String id, IModel<T> model) {
        super(id, model);
    }

    @Override
    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.replaceComponentTagBody(markupStream, openTag, this.getStringValue());
    }

    private String getStringValue() {
        Enum value = (Enum)this.getModelObject();
        String converted = value != null ? this.getString(this.resourceKey(value)) : this.nullValue();
        return this.getDefaultModelObjectAsString(converted);
    }

    protected String resourceKey(T value) {
        return Classes.simpleName(((Enum)value).getDeclaringClass()) + '.' + ((Enum)value).name();
    }

    protected String nullValue() {
        return "";
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.setType(XmlTag.TagType.OPEN);
    }
}

