/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.camel.component.metrics.routepolicy.MetricsRegistryService;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.CamelMetrics;
import org.apache.syncope.common.lib.to.CamelRouteTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.CamelRouteDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.CamelRoute;
import org.apache.syncope.core.provisioning.api.data.CamelRouteDataBinder;
import org.apache.syncope.core.provisioning.camel.CamelException;
import org.apache.syncope.core.provisioning.camel.SyncopeCamelContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CamelRouteLogic
extends AbstractTransactionalLogic<CamelRouteTO> {
    @Autowired
    private CamelRouteDAO routeDAO;
    @Autowired
    private CamelRouteDataBinder binder;
    @Autowired
    private SyncopeCamelContext context;

    @PreAuthorize(value="hasRole('ROUTE_LIST')")
    @Transactional(readOnly=true)
    public List<CamelRouteTO> list(AnyTypeKind anyTypeKind) {
        ArrayList<CamelRouteTO> routes = new ArrayList<CamelRouteTO>();
        this.routeDAO.find(anyTypeKind).forEach(route -> routes.add(this.binder.getRouteTO(route)));
        return routes;
    }

    @PreAuthorize(value="hasRole('ROUTE_READ')")
    @Transactional(readOnly=true)
    public CamelRouteTO read(AnyTypeKind anyTypeKind, String key) {
        CamelRoute route = this.routeDAO.find(key);
        if (route == null) {
            throw new NotFoundException("CamelRoute with key=" + key);
        }
        if (route.getAnyTypeKind() != anyTypeKind) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + anyTypeKind + ", expected " + route.getAnyTypeKind());
            throw sce;
        }
        return this.binder.getRouteTO(route);
    }

    @PreAuthorize(value="hasRole('ROUTE_UPDATE')")
    public void update(AnyTypeKind anyTypeKind, CamelRouteTO routeTO) {
        CamelRoute route = this.routeDAO.find(routeTO.getKey());
        if (route == null) {
            throw new NotFoundException("CamelRoute with key=" + routeTO.getKey());
        }
        if (route.getAnyTypeKind() != anyTypeKind) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + anyTypeKind + ", expected " + route.getAnyTypeKind());
            throw sce;
        }
        String originalContent = route.getContent();
        LOG.debug("Updating route {} with content {}", (Object)routeTO.getKey(), (Object)routeTO.getContent());
        this.binder.update(route, routeTO);
        try {
            this.context.updateContext(routeTO.getKey());
        }
        catch (CamelException e) {
            LOG.debug("Update of route {} failed, reverting", (Object)routeTO.getKey());
            this.context.restoreRoute(routeTO.getKey(), originalContent);
            throw e;
        }
    }

    @PreAuthorize(value="hasRole('ROUTE_UPDATE')")
    public void restartContext() {
        this.context.restartContext();
    }

    @PreAuthorize(value="isAuthenticated()")
    public CamelMetrics metrics() {
        CamelMetrics metrics = new CamelMetrics();
        MetricsRegistryService registryService = (MetricsRegistryService)this.context.getCamelContext().hasService(MetricsRegistryService.class);
        if (registryService == null) {
            LOG.warn("Camel metrics not available");
        } else {
            MetricRegistry registry = registryService.getMetricsRegistry();
            registry.getTimers().entrySet().stream().map(entry -> {
                CamelMetrics.MeanRate meanRate = new CamelMetrics.MeanRate();
                meanRate.setRouteId(StringUtils.substringBetween((String)((String)entry.getKey()), (String)".", (String)"."));
                meanRate.setValue(((Timer)entry.getValue()).getMeanRate());
                return meanRate;
            }).forEachOrdered(meanRate -> metrics.getResponseMeanRates().add(meanRate));
            Collections.sort(metrics.getResponseMeanRates(), (o1, o2) -> Collections.reverseOrder(Comparator.naturalOrder()).compare(o1.getValue(), o2.getValue()));
        }
        return metrics;
    }

    protected CamelRouteTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof CamelRouteTO)) continue;
                key = ((CamelRouteTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getRouteTO(this.routeDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

