/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnit;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.provisioning.java.propagation.DeletingLinkedAccount;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional(rollbackFor={Throwable.class})
public class PropagationManagerImpl
implements PropagationManager {
    protected static final Logger LOG = LoggerFactory.getLogger(PropagationManager.class);
    @Autowired
    protected VirSchemaDAO virSchemaDAO;
    @Autowired
    protected ExternalResourceDAO resourceDAO;
    @Autowired
    protected EntityFactory entityFactory;
    @Autowired
    protected ConnObjectUtils connObjectUtils;
    @Autowired
    protected MappingManager mappingManager;
    @Autowired
    protected DerAttrHandler derAttrHandler;
    @Autowired
    protected AnyUtilsFactory anyUtilsFactory;

    public List<PropagationTaskInfo> getCreateTasks(AnyTypeKind kind, String key, Boolean enable, PropagationByResource<String> propByRes, Collection<AttrTO> vAttrs, Collection<String> noPropResourceKeys) {
        return this.getCreateTasks(this.anyUtilsFactory.getInstance(kind).dao().authFind(key), null, enable, propByRes, null, vAttrs, noPropResourceKeys);
    }

    public List<PropagationTaskInfo> getUserCreateTasks(String key, String password, Boolean enable, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<AttrTO> vAttrs, Collection<String> noPropResourceKeys) {
        return this.getCreateTasks(this.anyUtilsFactory.getInstance(AnyTypeKind.USER).dao().authFind(key), password, enable, propByRes, propByLinkedAccount, vAttrs, noPropResourceKeys);
    }

    protected List<PropagationTaskInfo> getCreateTasks(Any<?> any, String password, Boolean enable, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<AttrTO> vAttrs, Collection<String> noPropResourceKeys) {
        if ((propByRes == null || propByRes.isEmpty()) && (propByLinkedAccount == null || propByLinkedAccount.isEmpty())) {
            return Collections.emptyList();
        }
        if (noPropResourceKeys != null) {
            if (propByRes != null) {
                propByRes.get(ResourceOperation.CREATE).removeAll(noPropResourceKeys);
            }
            if (propByLinkedAccount != null) {
                propByLinkedAccount.get(ResourceOperation.CREATE).removeIf(account -> noPropResourceKeys.contains(account.getLeft()));
            }
        }
        return this.createTasks(any, password, true, enable, propByRes, propByLinkedAccount, vAttrs);
    }

    public List<PropagationTaskInfo> getUpdateTasks(AnyTypeKind kind, String key, boolean changePwd, Boolean enable, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<AttrTO> vAttrs, Collection<String> noPropResourceKeys) {
        return this.getUpdateTasks(this.anyUtilsFactory.getInstance(kind).dao().authFind(key), null, changePwd, enable, propByRes, propByLinkedAccount, vAttrs, noPropResourceKeys);
    }

    public List<PropagationTaskInfo> getUserUpdateTasks(UserWorkflowResult<Pair<UserPatch, Boolean>> wfResult, boolean changePwd, Collection<String> noPropResourceKeys) {
        return this.getUpdateTasks(this.anyUtilsFactory.getInstance(AnyTypeKind.USER).dao().authFind(((UserPatch)((Pair)wfResult.getResult()).getLeft()).getKey()), ((UserPatch)((Pair)wfResult.getResult()).getLeft()).getPassword() == null ? null : (String)((UserPatch)((Pair)wfResult.getResult()).getLeft()).getPassword().getValue(), changePwd, (Boolean)((Pair)wfResult.getResult()).getRight(), (PropagationByResource<String>)wfResult.getPropByRes(), (PropagationByResource<Pair<String, String>>)wfResult.getPropByLinkedAccount(), (Collection<AttrTO>)((UserPatch)((Pair)wfResult.getResult()).getLeft()).getVirAttrs(), noPropResourceKeys);
    }

    public List<PropagationTaskInfo> getUserUpdateTasks(UserWorkflowResult<Pair<UserPatch, Boolean>> wfResult) {
        List<Object> tasks;
        UserPatch userPatch = (UserPatch)((Pair)wfResult.getResult()).getLeft();
        if (userPatch.getPassword() == null) {
            tasks = this.getUserUpdateTasks(wfResult, false, null);
        } else {
            tasks = new ArrayList();
            UserWorkflowResult pwdWFResult = new UserWorkflowResult(wfResult.getResult(), new PropagationByResource(), wfResult.getPropByLinkedAccount(), wfResult.getPerformedTasks());
            HashSet<String> pwdResourceNames = new HashSet<String>(userPatch.getPassword().getResources());
            Collection allResourceNames = this.anyUtilsFactory.getInstance(AnyTypeKind.USER).dao().findAllResourceKeys(userPatch.getKey());
            pwdResourceNames.retainAll(allResourceNames);
            pwdWFResult.getPropByRes().addAll(ResourceOperation.UPDATE, pwdResourceNames);
            if (!pwdWFResult.getPropByRes().isEmpty()) {
                HashSet<String> toBeExcluded = new HashSet<String>(allResourceNames);
                toBeExcluded.addAll(userPatch.getResources().stream().map(patchItem -> (String)patchItem.getValue()).collect(Collectors.toList()));
                toBeExcluded.removeAll(pwdResourceNames);
                tasks.addAll(this.getUserUpdateTasks((UserWorkflowResult<Pair<UserPatch, Boolean>>)pwdWFResult, true, toBeExcluded));
            }
            UserWorkflowResult noPwdWFResult = new UserWorkflowResult(wfResult.getResult(), new PropagationByResource(), new PropagationByResource(), wfResult.getPerformedTasks());
            noPwdWFResult.getPropByRes().merge(wfResult.getPropByRes());
            noPwdWFResult.getPropByRes().removeAll(pwdResourceNames);
            noPwdWFResult.getPropByRes().purge();
            if (!noPwdWFResult.getPropByRes().isEmpty()) {
                tasks.addAll(this.getUserUpdateTasks((UserWorkflowResult<Pair<UserPatch, Boolean>>)noPwdWFResult, false, pwdResourceNames));
            }
            tasks = tasks.stream().distinct().collect(Collectors.toList());
        }
        return tasks;
    }

    protected List<PropagationTaskInfo> getUpdateTasks(Any<?> any, String password, boolean changePwd, Boolean enable, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<AttrTO> vAttrs, Collection<String> noPropResourceKeys) {
        if (noPropResourceKeys != null) {
            if (propByRes != null) {
                propByRes.removeAll(noPropResourceKeys);
            }
            if (propByLinkedAccount != null) {
                propByLinkedAccount.get(ResourceOperation.CREATE).removeIf(account -> noPropResourceKeys.contains(account.getLeft()));
                propByLinkedAccount.get(ResourceOperation.UPDATE).removeIf(account -> noPropResourceKeys.contains(account.getLeft()));
                propByLinkedAccount.get(ResourceOperation.DELETE).removeIf(account -> noPropResourceKeys.contains(account.getLeft()));
            }
        }
        return this.createTasks(any, password, changePwd, enable, (PropagationByResource<String>)(propByRes == null ? new PropagationByResource() : propByRes), propByLinkedAccount, vAttrs);
    }

    public List<PropagationTaskInfo> getDeleteTasks(AnyTypeKind kind, String key, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<String> noPropResourceKeys) {
        return this.getDeleteTasks(this.anyUtilsFactory.getInstance(kind).dao().authFind(key), propByRes, propByLinkedAccount, noPropResourceKeys);
    }

    protected List<PropagationTaskInfo> getDeleteTasks(Any<?> any, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<String> noPropResourceKeys) {
        PropagationByResource localPropByRes = new PropagationByResource();
        if (propByRes == null || propByRes.isEmpty()) {
            localPropByRes.addAll(ResourceOperation.DELETE, this.anyUtilsFactory.getInstance(any).dao().findAllResourceKeys(any.getKey()));
        } else {
            localPropByRes.merge(propByRes);
        }
        if (noPropResourceKeys != null) {
            localPropByRes.removeAll(noPropResourceKeys);
            if (propByLinkedAccount != null) {
                propByLinkedAccount.get(ResourceOperation.CREATE).removeIf(account -> noPropResourceKeys.contains(account.getLeft()));
                propByLinkedAccount.get(ResourceOperation.UPDATE).removeIf(account -> noPropResourceKeys.contains(account.getLeft()));
                propByLinkedAccount.get(ResourceOperation.DELETE).removeIf(account -> noPropResourceKeys.contains(account.getLeft()));
            }
        }
        return this.createTasks(any, null, false, false, (PropagationByResource<String>)localPropByRes, propByLinkedAccount, null);
    }

    public PropagationTaskInfo newTask(DerAttrHandler derAttrHandler, Any<?> any, ExternalResource resource, ResourceOperation operation, Provision provision, Stream<? extends Item> mappingItems, Pair<String, Set<Attribute>> preparedAttrs) {
        PropagationTaskInfo task = new PropagationTaskInfo(resource);
        task.setObjectClassName(provision.getObjectClass().getObjectClassValue());
        task.setAnyTypeKind(any.getType().getKind());
        task.setAnyType(any.getType().getKey());
        task.setEntityKey(any.getKey());
        task.setOperation(operation);
        task.setConnObjectKey((String)preparedAttrs.getLeft());
        ArrayList mandatoryMissing = new ArrayList();
        ArrayList mandatoryNullOrEmpty = new ArrayList();
        mappingItems.filter(item -> !item.isConnObjectKey() && JexlUtils.evaluateMandatoryCondition((String)item.getMandatoryCondition(), (Any)any, (DerAttrHandler)derAttrHandler)).forEach(item -> {
            Attribute attr = AttributeUtil.find((String)item.getExtAttrName(), (Set)((Set)preparedAttrs.getRight()));
            if (attr == null) {
                mandatoryMissing.add(item.getExtAttrName());
            } else if (CollectionUtils.isEmpty((Collection)attr.getValue())) {
                mandatoryNullOrEmpty.add(item.getExtAttrName());
            }
        });
        if (!mandatoryMissing.isEmpty()) {
            ((Set)preparedAttrs.getRight()).add(AttributeBuilder.build((String)"__MANDATORY_MISSING__", mandatoryMissing));
        }
        if (!mandatoryNullOrEmpty.isEmpty()) {
            ((Set)preparedAttrs.getRight()).add(AttributeBuilder.build((String)"__MANDATORY_NULL_OR_EMPTY__", mandatoryNullOrEmpty));
        }
        task.setAttributes(POJOHelper.serialize((Object)preparedAttrs.getRight()));
        return task;
    }

    protected List<PropagationTaskInfo> createTasks(Any<?> any, String password, boolean changePwd, Boolean enable, PropagationByResource<String> propByRes, PropagationByResource<Pair<String, String>> propByLinkedAccount, Collection<AttrTO> vAttrs) {
        LOG.debug("Provisioning {}:\n{}", any, propByRes);
        propByRes.purge();
        LOG.debug("After purge {}:\n{}", any, propByRes);
        HashSet virtualResources = new HashSet();
        virtualResources.addAll(propByRes.get(ResourceOperation.CREATE));
        virtualResources.addAll(propByRes.get(ResourceOperation.UPDATE));
        virtualResources.addAll(this.anyUtilsFactory.getInstance(any).dao().findAllResourceKeys(any.getKey()));
        HashMap vAttrMap = new HashMap();
        if (vAttrs != null) {
            vAttrs.forEach(vAttr -> {
                VirSchema schema = (VirSchema)this.virSchemaDAO.find(vAttr.getSchema());
                if (schema == null) {
                    LOG.warn("Ignoring invalid {} {}", (Object)VirSchema.class.getSimpleName(), (Object)vAttr.getSchema());
                } else if (schema.isReadonly()) {
                    LOG.warn("Ignoring read-only {} {}", (Object)VirSchema.class.getSimpleName(), (Object)vAttr.getSchema());
                } else if (this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).contains((Schema)schema) && virtualResources.contains(schema.getProvision().getResource().getKey())) {
                    HashSet<Attribute> values = (HashSet<Attribute>)vAttrMap.get(schema.getProvision().getResource().getKey());
                    if (values == null) {
                        values = new HashSet<Attribute>();
                        vAttrMap.put(schema.getProvision().getResource().getKey(), values);
                    }
                    values.add(AttributeBuilder.build((String)schema.getExtAttrName(), (Collection)vAttr.getValues()));
                    if (!propByRes.contains(ResourceOperation.CREATE, (Serializable)((Object)schema.getProvision().getResource().getKey()))) {
                        propByRes.add(ResourceOperation.UPDATE, (Serializable)((Object)schema.getProvision().getResource().getKey()));
                    }
                } else {
                    LOG.warn("{} not owned by or {} not allowed for {}", new Object[]{schema.getProvision().getResource(), schema, any});
                }
            });
        }
        LOG.debug("With virtual attributes {}:\n{}\n{}", new Object[]{any, propByRes, vAttrMap});
        ArrayList<PropagationTaskInfo> tasks = new ArrayList<PropagationTaskInfo>();
        propByRes.asMap().forEach((resourceKey, operation) -> {
            Stream mappingItems;
            ExternalResource resource = this.resourceDAO.find(resourceKey);
            Provision provision = resource == null ? null : (Provision)resource.getProvision(any.getType()).orElse(null);
            Stream<Object> stream = mappingItems = provision == null ? Stream.empty() : MappingUtils.getPropagationItems(provision.getMapping().getItems().stream());
            if (resource == null) {
                LOG.error("Invalid resource name specified: {}, ignoring...", resourceKey);
            } else if (provision == null) {
                LOG.error("No provision specified on resource {} for type {}, ignoring...", (Object)resource, (Object)any.getType());
            } else if (provision.getMapping() == null || provision.getMapping().getItems().isEmpty()) {
                LOG.warn("Requesting propagation for {} but no propagation mapping provided for {}", (Object)any.getType(), (Object)resource);
            } else {
                Pair preparedAttrs = this.mappingManager.prepareAttrsFromAny(any, password, changePwd, enable, provision);
                if (vAttrMap.containsKey(resourceKey)) {
                    ((Set)preparedAttrs.getRight()).addAll((Collection)vAttrMap.get(resourceKey));
                }
                PropagationTaskInfo task = this.newTask(this.derAttrHandler, any, resource, (ResourceOperation)operation, provision, mappingItems, (Pair<String, Set<Attribute>>)preparedAttrs);
                task.setOldConnObjectKey(propByRes.getOldConnObjectKey(resourceKey));
                tasks.add(task);
                LOG.debug("PropagationTask created: {}", (Object)task);
            }
        });
        if (any instanceof User && propByLinkedAccount != null) {
            User user = (User)any;
            propByLinkedAccount.asMap().forEach((accountInfo, operation) -> {
                Stream mappingItems;
                LinkedAccount account = user.getLinkedAccount((String)accountInfo.getLeft(), (String)accountInfo.getRight()).orElse(null);
                if (account == null && operation == ResourceOperation.DELETE) {
                    account = new DeletingLinkedAccount(user, this.resourceDAO.find((String)accountInfo.getLeft()), (String)accountInfo.getRight());
                }
                Provision provision = account == null || account.getResource() == null ? null : (Provision)account.getResource().getProvision(AnyTypeKind.USER.name()).orElse(null);
                Stream<Object> stream = mappingItems = provision == null ? Stream.empty() : MappingUtils.getPropagationItems(provision.getMapping().getItems().stream());
                if (account == null) {
                    LOG.error("Invalid operation {} on deleted account {} on resource {}, ignoring...", new Object[]{operation, accountInfo.getRight(), accountInfo.getLeft()});
                } else if (account.getResource() == null) {
                    LOG.error("Invalid resource name specified: {}, ignoring...", accountInfo.getLeft());
                } else if (provision == null) {
                    LOG.error("No provision specified on resource {} for type {}, ignoring...", (Object)account.getResource(), (Object)AnyTypeKind.USER.name());
                } else if (provision.getMapping() == null || provision.getMapping().getItems().isEmpty()) {
                    LOG.warn("Requesting propagation for {} but no propagation mapping provided for {}", (Object)AnyTypeKind.USER.name(), (Object)account.getResource());
                } else {
                    PropagationTaskInfo accountTask = this.newTask(this.derAttrHandler, (Any<?>)user, account.getResource(), (ResourceOperation)operation, provision, mappingItems, (Pair<String, Set<Attribute>>)Pair.of((Object)account.getConnObjectKeyValue(), (Object)this.mappingManager.prepareAttrsFromLinkedAccount(user, account, password, true, provision)));
                    tasks.add(accountTask);
                    LOG.debug("PropagationTask created for Linked Account {}: {}", (Object)account.getConnObjectKeyValue(), (Object)accountTask);
                }
            });
        }
        return tasks;
    }

    public List<PropagationTaskInfo> createTasks(Realm realm, PropagationByResource<String> propByRes, Collection<String> noPropResourceKeys) {
        if (noPropResourceKeys != null) {
            propByRes.removeAll(noPropResourceKeys);
        }
        LOG.debug("Provisioning {}:\n{}", (Object)realm, propByRes);
        propByRes.purge();
        LOG.debug("After purge {}:\n{}", (Object)realm, propByRes);
        ArrayList<PropagationTaskInfo> tasks = new ArrayList<PropagationTaskInfo>();
        propByRes.asMap().forEach((resourceKey, operation) -> {
            OrgUnit orgUnit;
            ExternalResource resource = this.resourceDAO.find(resourceKey);
            OrgUnit orgUnit2 = orgUnit = resource == null ? null : resource.getOrgUnit();
            if (resource == null) {
                LOG.error("Invalid resource name specified: {}, ignoring...", resourceKey);
            } else if (orgUnit == null) {
                LOG.error("No orgUnit specified on resource {}, ignoring...", (Object)resource);
            } else if (StringUtils.isBlank((CharSequence)orgUnit.getConnObjectLink())) {
                LOG.warn("Requesting propagation for {} but no ConnObjectLink provided for {}", (Object)realm.getFullPath(), (Object)resource);
            } else {
                PropagationTaskInfo task = new PropagationTaskInfo(resource);
                task.setObjectClassName(orgUnit.getObjectClass().getObjectClassValue());
                task.setEntityKey(realm.getKey());
                task.setOperation(operation);
                task.setOldConnObjectKey(propByRes.getOldConnObjectKey(resource.getKey()));
                Pair preparedAttrs = this.mappingManager.prepareAttrsFromRealm(realm, orgUnit);
                task.setConnObjectKey((String)preparedAttrs.getLeft());
                task.setAttributes(POJOHelper.serialize((Object)preparedAttrs.getRight()));
                tasks.add(task);
                LOG.debug("PropagationTask created: {}", (Object)task);
            }
        });
        return tasks;
    }
}

