/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.Collection;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskCallable;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public class DefaultPropagationTaskCallable
implements PropagationTaskCallable {
    protected static final Logger LOG = LoggerFactory.getLogger(PropagationTaskCallable.class);
    @Autowired
    protected PropagationTaskExecutor taskExecutor;
    protected final String domain;
    protected final String username;
    protected final String delegatedBy;
    protected final Collection<? extends GrantedAuthority> authorities;
    protected PropagationTaskInfo taskInfo;
    protected PropagationReporter reporter;

    public DefaultPropagationTaskCallable() {
        SecurityContext ctx = SecurityContextHolder.getContext();
        this.domain = AuthContextUtils.getDomain();
        this.username = ctx.getAuthentication().getName();
        this.delegatedBy = AuthContextUtils.getDelegatedBy().orElse(null);
        this.authorities = ctx.getAuthentication().getAuthorities();
    }

    public void setTaskInfo(PropagationTaskInfo taskInfo) {
        this.taskInfo = taskInfo;
    }

    public void setReporter(PropagationReporter reporter) {
        this.reporter = reporter;
    }

    public TaskExec call() throws Exception {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)new User(this.username, "FAKE_PASSWORD", this.authorities), (Object)"FAKE_PASSWORD", this.authorities);
        auth.setDetails((Object)new SyncopeAuthenticationDetails(this.domain, this.delegatedBy));
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        LOG.debug("Execution started for {}", (Object)this.taskInfo);
        TaskExec execution = this.taskExecutor.execute(this.taskInfo, this.reporter);
        LOG.debug("Execution completed for {}, {}", (Object)this.taskInfo, (Object)execution);
        return execution;
    }
}

