/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.JWTAuthentication;
import org.apache.syncope.core.spring.security.SyncopeGrantedAuthority;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class JWTAuthenticationProvider
implements AuthenticationProvider {
    @Autowired
    private AuthDataAccessor dataAccessor;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        JWTAuthentication jwtAuthentication = (JWTAuthentication)authentication;
        AuthContextUtils.execWithAuthContext(jwtAuthentication.getDetails().getDomain(), () -> {
            Pair<String, Set<SyncopeGrantedAuthority>> authenticated = this.dataAccessor.authenticate(jwtAuthentication);
            jwtAuthentication.setUsername((String)authenticated.getLeft());
            jwtAuthentication.getAuthorities().addAll((Collection)authenticated.getRight());
            return null;
        });
        JwtClaims claims = jwtAuthentication.getClaims();
        long referenceTime = System.currentTimeMillis();
        Long expiryTime = claims.getExpiryTime();
        if (expiryTime != null && expiryTime * 1000L < referenceTime) {
            this.dataAccessor.removeExpired(claims.getTokenId());
            throw new CredentialsExpiredException("JWT is expired");
        }
        Long notBefore = claims.getNotBefore();
        if (notBefore != null && notBefore * 1000L > referenceTime) {
            throw new CredentialsExpiredException("JWT not valid yet");
        }
        jwtAuthentication.setAuthenticated(true);
        return jwtAuthentication;
    }

    public boolean supports(Class<?> authentication) {
        return JWTAuthentication.class.isAssignableFrom(authentication);
    }
}

