/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring;

import groovy.lang.GroovyClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.syncope.common.lib.policy.AccountRuleConf;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.common.lib.policy.PullCorrelationRuleConf;
import org.apache.syncope.common.lib.policy.PushCorrelationRuleConf;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.core.persistence.api.ImplementationLookup;
import org.apache.syncope.core.persistence.api.dao.AccountRule;
import org.apache.syncope.core.persistence.api.dao.PasswordRule;
import org.apache.syncope.core.persistence.api.dao.PullCorrelationRule;
import org.apache.syncope.core.persistence.api.dao.PushCorrelationRule;
import org.apache.syncope.core.persistence.api.dao.Reportlet;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public final class ImplementationManager {
    private static final Logger LOG = LoggerFactory.getLogger(ImplementationManager.class);
    private static final GroovyClassLoader GROOVY_CLASSLOADER = new GroovyClassLoader();
    private static final Map<String, Class<?>> CLASS_CACHE = Collections.synchronizedMap(new HashMap());

    public static Optional<Reportlet> buildReportlet(Implementation impl) throws InstantiationException, IllegalAccessException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return Optional.of(ImplementationManager.buildGroovy(impl));
            }
        }
        ReportletConf reportletConf = (ReportletConf)POJOHelper.deserialize((String)impl.getBody(), ReportletConf.class);
        Class reportletClass = ((ImplementationLookup)ApplicationContextProvider.getApplicationContext().getBean(ImplementationLookup.class)).getReportletClass(reportletConf.getClass());
        Reportlet reportlet = (Reportlet)ImplementationManager.buildJavaWithConf(reportletClass);
        if (reportlet == null) {
            LOG.warn("Could not find matching reportlet for {}", reportletConf.getClass());
        } else {
            reportlet.setConf(reportletConf);
        }
        return Optional.ofNullable(reportlet);
    }

    public static Optional<AccountRule> buildAccountRule(Implementation impl) throws InstantiationException, IllegalAccessException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return Optional.of(ImplementationManager.buildGroovy(impl));
            }
        }
        AccountRuleConf ruleConf = (AccountRuleConf)POJOHelper.deserialize((String)impl.getBody(), AccountRuleConf.class);
        Class ruleClass = ((ImplementationLookup)ApplicationContextProvider.getApplicationContext().getBean(ImplementationLookup.class)).getAccountRuleClass(ruleConf.getClass());
        AccountRule rule = (AccountRule)ImplementationManager.buildJavaWithConf(ruleClass);
        if (rule == null) {
            LOG.warn("Could not find matching account rule for {}", impl.getClass());
        } else {
            rule.setConf(ruleConf);
        }
        return Optional.ofNullable(rule);
    }

    public static Optional<PasswordRule> buildPasswordRule(Implementation impl) throws InstantiationException, IllegalAccessException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return Optional.of(ImplementationManager.buildGroovy(impl));
            }
        }
        PasswordRuleConf ruleConf = (PasswordRuleConf)POJOHelper.deserialize((String)impl.getBody(), PasswordRuleConf.class);
        Class ruleClass = ((ImplementationLookup)ApplicationContextProvider.getApplicationContext().getBean(ImplementationLookup.class)).getPasswordRuleClass(ruleConf.getClass());
        PasswordRule rule = (PasswordRule)ImplementationManager.buildJavaWithConf(ruleClass);
        if (rule == null) {
            LOG.warn("Could not find matching password rule for {}", impl.getClass());
        } else {
            rule.setConf(ruleConf);
        }
        return Optional.ofNullable(rule);
    }

    public static Optional<PullCorrelationRule> buildPullCorrelationRule(Implementation impl) throws InstantiationException, IllegalAccessException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return Optional.of(ImplementationManager.buildGroovy(impl));
            }
        }
        PullCorrelationRuleConf ruleConf = (PullCorrelationRuleConf)POJOHelper.deserialize((String)impl.getBody(), PullCorrelationRuleConf.class);
        Class ruleClass = ((ImplementationLookup)ApplicationContextProvider.getApplicationContext().getBean(ImplementationLookup.class)).getPullCorrelationRuleClass(ruleConf.getClass());
        PullCorrelationRule rule = (PullCorrelationRule)ImplementationManager.buildJavaWithConf(ruleClass);
        if (rule == null) {
            LOG.warn("Could not find matching pull correlation rule for {}", impl.getClass());
        } else {
            rule.setConf(ruleConf);
        }
        return Optional.ofNullable(rule);
    }

    public static Optional<PushCorrelationRule> buildPushCorrelationRule(Implementation impl) throws InstantiationException, IllegalAccessException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return Optional.of(ImplementationManager.buildGroovy(impl));
            }
        }
        PushCorrelationRuleConf ruleConf = (PushCorrelationRuleConf)POJOHelper.deserialize((String)impl.getBody(), PushCorrelationRuleConf.class);
        Class ruleClass = ((ImplementationLookup)ApplicationContextProvider.getApplicationContext().getBean(ImplementationLookup.class)).getPushCorrelationRuleClass(ruleConf.getClass());
        PushCorrelationRule rule = (PushCorrelationRule)ImplementationManager.buildJavaWithConf(ruleClass);
        if (rule == null) {
            LOG.warn("Could not find matching push correlation rule for {}", impl.getClass());
        } else {
            rule.setConf(ruleConf);
        }
        return Optional.ofNullable(rule);
    }

    public static <T> T build(Implementation impl) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        switch (impl.getEngine()) {
            case GROOVY: {
                return ImplementationManager.buildGroovy(impl);
            }
        }
        return ImplementationManager.buildJava(impl);
    }

    private static <T> T buildGroovy(Implementation impl) throws InstantiationException, IllegalAccessException {
        Class<?> clazz;
        if (CLASS_CACHE.containsKey(impl.getKey())) {
            clazz = CLASS_CACHE.get(impl.getKey());
        } else {
            clazz = GROOVY_CLASSLOADER.parseClass(impl.getBody());
            CLASS_CACHE.put(impl.getKey(), clazz);
        }
        return (T)ApplicationContextProvider.getBeanFactory().createBean(clazz, 2, false);
    }

    private static <T> T buildJava(Implementation impl) throws ClassNotFoundException {
        Class<?> clazz;
        if (CLASS_CACHE.containsKey(impl.getKey())) {
            clazz = CLASS_CACHE.get(impl.getKey());
        } else {
            clazz = Class.forName(impl.getBody());
            CLASS_CACHE.put(impl.getKey(), clazz);
        }
        return (T)ApplicationContextProvider.getBeanFactory().createBean(clazz, 2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T buildJavaWithConf(Class<T> clazz) {
        if (clazz != null) {
            String domainableBeanNameWithConf = AuthContextUtils.getDomain() + clazz.getName();
            DefaultListableBeanFactory beanFactory = ApplicationContextProvider.getBeanFactory();
            if (beanFactory.containsSingleton(domainableBeanNameWithConf)) {
                return (T)beanFactory.getSingleton(domainableBeanNameWithConf);
            }
            Object object = beanFactory.getSingletonMutex();
            synchronized (object) {
                if (beanFactory.containsSingleton(domainableBeanNameWithConf)) {
                    return (T)beanFactory.getSingleton(domainableBeanNameWithConf);
                }
                Object bean = beanFactory.createBean(clazz, 2, false);
                beanFactory.registerSingleton(domainableBeanNameWithConf, bean);
                return (T)bean;
            }
        }
        return null;
    }

    public static Class<?> purge(String implementation) {
        return CLASS_CACHE.remove(implementation);
    }

    private ImplementationManager() {
    }
}

