/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import net.tirasa.connid.bundles.googleapps.GoogleAppsCustomSchema;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;

public class GoogleAppsUtil {
    private static final Log LOG = Log.getLog(GoogleAppsUtil.class);
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    public static List<GoogleAppsCustomSchema> extractCustomSchemas(String json) {
        List customSchemasObj = null;
        try {
            customSchemasObj = (List)MAPPER.readValue(json, (TypeReference)new TypeReference<List<GoogleAppsCustomSchema>>(){});
        }
        catch (IOException e) {
            LOG.error((Throwable)e, "While validating customSchemaJSON", new Object[0]);
        }
        return customSchemasObj;
    }

    public static String getName(Name name) {
        if (name != null) {
            String email = name.getNameValue();
            if (StringUtil.isBlank((String)email)) {
                throw new InvalidAttributeValueException("Required attribute __NAME__ is blank");
            }
            return email;
        }
        throw new InvalidAttributeValueException("Required attribute __NAME__ is missing");
    }

    public static String getStringValueWithDefault(Attribute source, String defaultTo) {
        Object value = AttributeUtil.getSingleValue((Attribute)source);
        if (value instanceof String) {
            return (String)value;
        }
        if (null != value) {
            throw new InvalidAttributeValueException("The " + source.getName() + " attribute is not String value attribute. It has value with type " + value.getClass().getSimpleName());
        }
        return defaultTo;
    }

    public static Boolean getBooleanValueWithDefault(Attribute source, Boolean defaultTo) {
        Object value = AttributeUtil.getSingleValue((Attribute)source);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (null != value) {
            throw new InvalidAttributeValueException("The " + source.getName() + " attribute is not Boolean value attribute. It has value with type " + value.getClass().getSimpleName());
        }
        return defaultTo;
    }

    public static String generateLicenseId(String productId, String skuId, String userId) {
        if (StringUtil.isBlank((String)productId) || StringUtil.isBlank((String)skuId) || StringUtil.isBlank((String)userId)) {
            throw new IllegalArgumentException("productId, skuId and/or userId value(s) are not valid");
        }
        return productId + "/sku/" + skuId + "/user/" + userId;
    }
}

