/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.parser;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ItemDefinition;

public class ItemDefinitionParser
implements BpmnXMLConstants {
    public void parse(XMLStreamReader xtr, BpmnModel model) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "id"))) {
            String itemDefinitionId = model.getTargetNamespace() + ":" + xtr.getAttributeValue(null, "id");
            String structureRef = xtr.getAttributeValue(null, "structureRef");
            if (StringUtils.isNotEmpty((CharSequence)structureRef)) {
                ItemDefinition item = new ItemDefinition();
                item.setId(itemDefinitionId);
                BpmnXMLUtil.addXMLLocation((BaseElement)item, xtr);
                int indexOfP = structureRef.indexOf(58);
                if (indexOfP != -1) {
                    String prefix = structureRef.substring(0, indexOfP);
                    String resolvedNamespace = model.getNamespace(prefix);
                    structureRef = resolvedNamespace + ":" + structureRef.substring(indexOfP + 1);
                } else {
                    structureRef = model.getTargetNamespace() + ":" + structureRef;
                }
                item.setStructureRef(structureRef);
                item.setItemKind(xtr.getAttributeValue(null, "itemKind"));
                BpmnXMLUtil.parseChildElements("itemDefinition", (BaseElement)item, xtr, model);
                model.addItemDefinition(itemDefinitionId, item);
            }
        }
    }
}

