/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.okta;

import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.authc.credentials.TokenClientCredentials;
import com.okta.sdk.client.Client;
import com.okta.sdk.client.Clients;
import com.okta.sdk.error.ErrorCause;
import com.okta.sdk.impl.resource.DefaultUserBuilder;
import com.okta.sdk.impl.resource.application.DefaultApplicationList;
import com.okta.sdk.impl.resource.group.DefaultGroupList;
import com.okta.sdk.impl.resource.user.DefaultUserList;
import com.okta.sdk.resource.CollectionResource;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.ResourceException;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationList;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.log.LogEvent;
import com.okta.sdk.resource.log.LogEventList;
import com.okta.sdk.resource.log.LogTarget;
import com.okta.sdk.resource.user.ChangePasswordRequest;
import com.okta.sdk.resource.user.PasswordCredential;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserBuilder;
import com.okta.sdk.resource.user.UserCredentials;
import com.okta.sdk.resource.user.UserList;
import com.okta.sdk.resource.user.UserStatus;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.tirasa.connid.bundles.okta.OktaConfiguration;
import net.tirasa.connid.bundles.okta.OktaFilterTranslator;
import net.tirasa.connid.bundles.okta.schema.OktaSchema;
import net.tirasa.connid.bundles.okta.utils.CipherAlgorithm;
import net.tirasa.connid.bundles.okta.utils.OktaAttribute;
import net.tirasa.connid.bundles.okta.utils.OktaEventType;
import net.tirasa.connid.bundles.okta.utils.OktaFilter;
import net.tirasa.connid.bundles.okta.utils.OktaFilterOp;
import net.tirasa.connid.bundles.okta.utils.OktaUtils;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassUtil;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.PoolableConnector;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.SyncOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

@ConnectorClass(configurationClass=OktaConfiguration.class, displayNameKey="okta.connector.display")
public class OktaConnector
implements Connector,
PoolableConnector,
CreateOp,
UpdateOp,
DeleteOp,
SchemaOp,
SyncOp,
TestOp,
SearchOp<OktaFilter> {
    private static final Log LOG = Log.getLog(OktaConnector.class);
    public static final String APPLICATION_NAME = ObjectClassUtil.createSpecialName((String)"APPLICATION");
    public static final ObjectClass APPLICATION = new ObjectClass(APPLICATION_NAME);
    public static final String SCHEMA_USER_EDITOR_PROFILE_API_URL = "/api/v1/meta/schemas/user/default";
    public static final String USER_API_URL = "/api/v1/users";
    public static final String APP_API_URL = "/api/v1/apps";
    public static final String GROUP_API_URL = "/api/v1/groups";
    public static final String LOG_API_URL = "/api/v1/logs";
    public static final String LIMIT = "50";
    public static final String USER = "USER";
    public static final String FILTER = "filter";
    public static final String CIPHER_ALGORITHM = "cipherAlgorithm";
    public static final String SALT = "salt";
    public static final String SALT_ORDER = "saltOrder";
    public static final String WORK_FACTOR = "workFactor";
    private static final Set<String> NOT_FOR_PROFILE = CollectionUtil.newReadOnlySet((Object[])new String[]{Name.NAME, OperationalAttributes.ENABLE_NAME, OperationalAttributes.PASSWORD_NAME, "id", "status", "oktaSecurityQuestion", "oktaSecurityAnswer"});
    private OktaConfiguration configuration;
    private Client client;
    private OktaSchema schema;

    public OktaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void init(Configuration configuration) {
        this.configuration = (OktaConfiguration)configuration;
        try {
            if (this.client == null) {
                this.client = Clients.builder().setOrgUrl(this.configuration.getDomain()).setClientCredentials((ClientCredentials)new TokenClientCredentials(this.configuration.getOktaApiToken())).setRetryMaxAttempts(this.configuration.getRateLimitMaxRetries()).setRetryMaxElapsed(this.configuration.getRetryMaxElapsed()).setConnectionTimeout(this.configuration.getRequestTimeout()).build();
            }
        }
        catch (Exception ex) {
            OktaUtils.wrapGeneralError("Could not create Okta client", ex);
        }
        if (this.schema == null) {
            this.schema = new OktaSchema(this.client);
        }
        LOG.ok("Connector {0} successfully inited", new Object[]{this.getClass().getName()});
    }

    public void checkAlive() {
        LOG.ok("Check Alive", new Object[0]);
    }

    public Uid create(ObjectClass objectClass, Set<Attribute> createAttributes, OperationOptions options) {
        LOG.ok("Connector CREATE", new Object[0]);
        if (createAttributes == null || createAttributes.isEmpty()) {
            OktaUtils.handleGeneralError("Set of Attributes value is null or empty");
        }
        AttributesAccessor accessor = new AttributesAccessor(createAttributes);
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            User result = null;
            Attribute status = accessor.find(OperationalAttributes.ENABLE_NAME);
            Attribute email = accessor.find("email");
            try {
                DefaultUserBuilder userBuilder = new DefaultUserBuilder();
                if (status == null || CollectionUtil.isEmpty((Collection)status.getValue())) {
                    LOG.warn("{0} attribute value not correct or not found, won't handle User status", new Object[]{OperationalAttributes.ENABLE_NAME});
                } else {
                    userBuilder.setActive(AttributeUtil.getBooleanValue((Attribute)status));
                }
                GuardedString password = accessor.getPassword();
                if (password != null) {
                    String securityAnswer;
                    String passwordValue = SecurityUtil.decrypt((GuardedString)password);
                    String passwordHashAlgorithm = accessor.findString(CIPHER_ALGORITHM);
                    if (StringUtil.isNotBlank((String)passwordHashAlgorithm)) {
                        String salt = accessor.findString(SALT);
                        String saltOrder = accessor.findString(SALT_ORDER);
                        switch (CipherAlgorithm.valueOfLabel(passwordHashAlgorithm)) {
                            case SHA: 
                            case SHA1: 
                            case SSHA: 
                            case SSHA1: {
                                userBuilder.setSha1PasswordHash(passwordValue, salt, saltOrder);
                                break;
                            }
                            case SHA256: 
                            case SSHA256: {
                                userBuilder.setSha256PasswordHash(passwordValue, salt, saltOrder);
                                break;
                            }
                            case SHA512: 
                            case SSHA512: {
                                userBuilder.setSha512PasswordHash(passwordValue, salt, saltOrder);
                                break;
                            }
                            case BCRYPT: {
                                userBuilder.setBcryptPasswordHash(passwordValue, salt, accessor.findInteger(WORK_FACTOR).intValue());
                                break;
                            }
                            default: {
                                OktaUtils.handleGeneralError("Hash Algorithm not supported : " + passwordHashAlgorithm);
                                break;
                            }
                        }
                    } else {
                        userBuilder.setPassword(passwordValue.toCharArray());
                    }
                    String securityQuestion = accessor.findString("oktaSecurityQuestion");
                    if (StringUtil.isNotBlank((String)securityQuestion)) {
                        userBuilder.setSecurityQuestion(securityQuestion);
                    }
                    if (StringUtil.isNotBlank((String)(securityAnswer = accessor.findString("oktaSecurityAnswer")))) {
                        userBuilder.setSecurityQuestionAnswer(securityAnswer);
                    }
                }
                this.buildProfile((UserBuilder)userBuilder, accessor, objectClass);
                Optional.ofNullable(accessor.findList("oktaGroups")).map(Collection::stream).orElseGet(Stream::empty).map(Object::toString).forEach(arg_0 -> OktaConnector.lambda$create$0((UserBuilder)userBuilder, arg_0));
                result = userBuilder.buildAndCreate(this.client);
            }
            catch (Exception e) {
                OktaUtils.wrapGeneralError("Could not create User : " + AttributeUtil.getAsStringValue((Attribute)email), e);
            }
            if (result == null || result.getId() == null) {
                OktaUtils.handleGeneralError("Something wrong happened during user create, check logs");
            }
            return new Uid(result.getId());
        }
        LOG.warn("Create of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
        throw new UnsupportedOperationException("Create of type" + objectClass.getObjectClassValue() + " is not supported");
    }

    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        LOG.ok("Connector UPDATE", new Object[0]);
        if (replaceAttributes == null || replaceAttributes.isEmpty()) {
            OktaUtils.handleGeneralError("Set of Attributes value is null or empty");
        }
        AttributesAccessor accessor = new AttributesAccessor(replaceAttributes);
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            Uid returnUid = uid;
            User user = this.client.getUser(uid.getUidValue());
            GuardedString password = accessor.getPassword();
            if (password != null && StringUtil.isNotBlank((String)SecurityUtil.decrypt((GuardedString)password))) {
                GuardedString currentPasswordValue;
                Attribute currentPassword = accessor.find(OperationalAttributes.CURRENT_PASSWORD_NAME);
                GuardedString guardedString = currentPasswordValue = currentPassword == null ? null : AttributeUtil.getGuardedStringValue((Attribute)currentPassword);
                if (currentPasswordValue != null && StringUtil.isNotBlank((String)SecurityUtil.decrypt((GuardedString)currentPasswordValue))) {
                    this.selfPasswordUpdate(user, currentPasswordValue, password);
                } else {
                    try {
                        UserCredentials userCredentials = (UserCredentials)this.client.instantiate(UserCredentials.class);
                        PasswordCredential passwordCredentials = (PasswordCredential)this.client.instantiate(PasswordCredential.class);
                        passwordCredentials.setValue(SecurityUtil.decrypt((GuardedString)password).toCharArray());
                        userCredentials.setPassword(passwordCredentials);
                        user.setCredentials(userCredentials);
                    }
                    catch (Exception e) {
                        OktaUtils.wrapGeneralError("Could not update password for User " + uid.getUidValue(), e);
                    }
                }
            }
            try {
                this.updateUserAttributes(user, replaceAttributes);
                User updatedUser = user.update(Boolean.valueOf(true));
                this.updateUserStatus(updatedUser, accessor.find(OperationalAttributes.ENABLE_NAME));
                returnUid = new Uid(updatedUser.getId());
            }
            catch (Exception e) {
                OktaUtils.wrapGeneralError("Could not update User " + uid.getUidValue() + " from attributes ", e);
            }
            if (accessor.findList("oktaGroups") != null) {
                try {
                    List groupsToAssign = CollectionUtil.nullAsEmpty((List)accessor.findList("oktaGroups"));
                    Set assignedGroups = Optional.ofNullable(user.listGroups()).map(CollectionResource::stream).orElseGet(Stream::empty).map(Group::getId).collect(Collectors.toSet());
                    CollectionUtil.nullAsEmpty((List)groupsToAssign).stream().forEach(grp -> {
                        if (!assignedGroups.contains(grp.toString())) {
                            try {
                                user.addToGroup(grp.toString());
                                LOG.ok("User added to Group: {0} after update", new Object[]{grp});
                            }
                            catch (Exception ex) {
                                LOG.error((Throwable)ex, "Could not add User {0} to Group {1} ", new Object[]{uid.getUidValue(), grp});
                                OktaUtils.handleGeneralError("Could not add User to Group ", ex);
                            }
                        }
                    });
                    CollectionUtil.nullAsEmpty(assignedGroups).stream().forEach(grp -> {
                        if (!groupsToAssign.contains(grp)) {
                            try {
                                this.client.getGroup(grp).removeUser(uid.getUidValue());
                                LOG.ok("User removed from group: {0} after update", new Object[]{grp});
                            }
                            catch (Exception ex) {
                                LOG.error((Throwable)ex, "Could not remove User {0} from Group {1} ", new Object[]{uid.getUidValue(), grp});
                                OktaUtils.handleGeneralError("Could not remove User from Group " + grp, ex);
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex, "Could not list groups for User {0}", new Object[]{uid.getUidValue()});
                    OktaUtils.handleGeneralError("Could not list groups for User", ex);
                }
            }
            return returnUid;
        }
        LOG.warn("Update of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
        throw new UnsupportedOperationException("Update of type" + objectClass.getObjectClassValue() + " is not supported");
    }

    public void delete(ObjectClass objectClass, Uid uid, OperationOptions options) {
        LOG.ok("Connector DELETE", new Object[0]);
        if (StringUtil.isBlank((String)uid.getUidValue())) {
            LOG.error("Uid not provided or empty ", new Object[0]);
            throw new InvalidAttributeValueException("Uid value not provided or empty");
        }
        if (objectClass == null) {
            LOG.error("Object value not provided {0} ", new Object[]{objectClass});
            throw new InvalidAttributeValueException("Object value not provided");
        }
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            try {
                User user = this.client.getUser(uid.getUidValue());
                user.delete(Boolean.valueOf(false));
                user.delete(Boolean.valueOf(false));
            }
            catch (Exception e) {
                OktaUtils.wrapGeneralError("Could not delete User " + uid.getUidValue(), e);
            }
        } else if (APPLICATION.equals((Object)objectClass)) {
            try {
                Application application = this.client.getApplication(uid.getUidValue());
                application.deactivate();
                application.delete();
            }
            catch (Exception e) {
                OktaUtils.wrapGeneralError("Could not delete Application " + uid.getUidValue(), e);
            }
        } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
            try {
                Group group = this.client.getGroup(uid.getUidValue());
                group.delete();
            }
            catch (Exception e) {
                OktaUtils.wrapGeneralError("Could not delete Group " + uid.getUidValue(), e);
            }
        } else {
            LOG.warn("Delete of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
            throw new UnsupportedOperationException("Delete of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    public Schema schema() {
        LOG.ok("Building SCHEMA definition", new Object[0]);
        return this.schema.getSchema();
    }

    public SyncToken getLatestSyncToken(ObjectClass objectClass) {
        LOG.ok("check the ObjectClass", new Object[0]);
        long maxlastUpdate = 0L;
        try {
            maxlastUpdate = this.getLastLogEvent(objectClass);
            LOG.ok("getLatestSyncToken on {0} - {1}", new Object[]{objectClass, maxlastUpdate});
        }
        catch (Exception e) {
            OktaUtils.handleGeneralError("Error during retrieve SyncToken", e);
        }
        return new SyncToken((Object)maxlastUpdate);
    }

    public void sync(ObjectClass objectClass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        if (handler == null) {
            OktaUtils.handleGeneralError("Result handler is null");
        }
        HashSet<String> attributesToGet = new HashSet<String>();
        if (options.getAttributesToGet() != null) {
            attributesToGet.addAll(Arrays.asList(options.getAttributesToGet()));
            attributesToGet.add("lastUpdated");
        }
        Long tokenValue = null;
        if (token == null || token.getValue() == null) {
            LOG.info("Synchronization with empty token.", new Object[0]);
        } else {
            LOG.info("Synchronization with token.", new Object[0]);
            tokenValue = Long.valueOf(token.getValue().toString());
        }
        LOG.info("Execute sync query {0} on {1}", new Object[]{tokenValue, objectClass});
        LogEventList logEvents = this.getEvents(objectClass, tokenValue == null ? null : OktaUtils.convertToDate(tokenValue));
        if (logEvents != null) {
            logEvents.stream().forEach(item -> {
                ConnectorObject connObj = null;
                try {
                    if (this.isDeleteEvent(item.getEventType())) {
                        connObj = this.fromLogEvent(((LogTarget)item.getTarget().get(0)).getId(), item.getPublished().getTime(), objectClass);
                    } else {
                        try {
                            if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
                                User result = this.client.getUser(((LogTarget)item.getTarget().get(0)).getId());
                                connObj = this.fromUser(result, attributesToGet);
                            } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
                                Group result = this.client.getGroup(((LogTarget)item.getTarget().get(0)).getId());
                                connObj = this.fromGroup(result, attributesToGet);
                            } else {
                                Application result = this.client.getApplication(((LogTarget)item.getTarget().get(0)).getId());
                                connObj = this.fromApplication(result, attributesToGet);
                            }
                        }
                        catch (Exception ex) {
                            LOG.info("{0} not found", new Object[]{((LogTarget)item.getTarget().get(0)).getId()});
                        }
                    }
                    if (connObj != null && !handler.handle(this.buildSyncDelta(connObj, (LogEvent)item).build())) {
                        LOG.ok("Stop processing of the sync result set", new Object[0]);
                        OktaUtils.handleGeneralError("Stop processing of the sync result set");
                    }
                }
                catch (Exception e) {
                    OktaUtils.handleGeneralError("Sync on " + objectClass + " error", e);
                }
            });
        }
    }

    public void test() {
        if (this.configuration != null && this.client != null) {
            try {
                new OktaSchema(this.client).getSchema();
            }
            catch (Exception ex) {
                OktaUtils.handleGeneralError("Test error. Problems with client service", ex);
            }
            LOG.ok("Test was successfull", new Object[0]);
        } else {
            LOG.error("Test error. No instance of the configuration class", new Object[0]);
        }
    }

    public Client getClient() {
        return this.client;
    }

    public FilterTranslator<OktaFilter> createFilterTranslator(ObjectClass oclass, OperationOptions options) {
        LOG.info("check the ObjectClass", new Object[0]);
        if (oclass == null) {
            throw new IllegalArgumentException("Object class not supported");
        }
        LOG.ok("The ObjectClass is ok", new Object[0]);
        return new OktaFilterTranslator(oclass);
    }

    public void executeQuery(ObjectClass objectClass, OktaFilter filter, ResultsHandler handler, OperationOptions options) {
        LOG.ok("Connector READ", new Object[0]);
        if (filter != null && filter.getAttribute() != null && filter.getValue() == null) {
            return;
        }
        HashSet<String> attributesToGet = new HashSet<String>();
        if (options.getAttributesToGet() != null) {
            attributesToGet.addAll(Arrays.asList(options.getAttributesToGet()));
        }
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            if (filter == null) {
                int remainingResults = -1;
                int pageSize = options.getPageSize() == null ? -1 : options.getPageSize();
                String cookie = options.getPagedResultsCookie();
                DefaultUserList userList = null;
                try {
                    if (pageSize != -1) {
                        String nextPage = StringUtil.isBlank((String)cookie) ? "/api/v1/users?limit=" + pageSize : cookie;
                        userList = (DefaultUserList)this.client.getDataStore().getResource(nextPage, DefaultUserList.class);
                        nextPage = userList.hasProperty("nextPage") && userList.getProperty("nextPage") != null ? userList.getProperty("nextPage").toString() : null;
                        cookie = userList.getCurrentPage().getItems().size() >= pageSize ? nextPage : null;
                    } else {
                        userList = (DefaultUserList)this.client.listUsers();
                    }
                }
                catch (Exception e) {
                    OktaUtils.wrapGeneralError("While getting Users!", e);
                }
                if (userList != null) {
                    for (User user : userList) {
                        handler.handle(this.fromUser(user, attributesToGet));
                    }
                }
                if (handler instanceof SearchResultsHandler) {
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(cookie, remainingResults));
                }
            } else {
                try {
                    if (filter.getFilters() == null && OktaFilter.ID_ATTRS.contains(filter.getAttribute()) && OktaFilterOp.EQUALS.equals((Object)filter.getFilterOp())) {
                        User user = this.client.getUser(filter.getValue());
                        handler.handle(this.fromUser(user, attributesToGet));
                    } else {
                        UserList users = this.client.listUsers(null, null, filter.toString(), null, null);
                        for (User user : users) {
                            if (handler.handle(this.fromUser(user, attributesToGet))) continue;
                            LOG.ok("Stop processing of the result set", new Object[0]);
                        }
                    }
                }
                catch (Exception e) {
                    OktaUtils.wrapGeneralError("While getting User : " + filter, e);
                }
            }
        } else if (APPLICATION.equals((Object)objectClass)) {
            if (filter == null) {
                int remainingResults = -1;
                int pageSize = options.getPageSize() == null ? -1 : options.getPageSize();
                String cookie = options.getPagedResultsCookie();
                DefaultApplicationList applicationList = null;
                try {
                    if (pageSize != -1) {
                        String nextPage = StringUtil.isBlank((String)cookie) ? "/api/v1/apps?limit=" + pageSize : cookie;
                        applicationList = (DefaultApplicationList)this.client.getDataStore().getResource(nextPage, DefaultApplicationList.class);
                        nextPage = applicationList.hasProperty("nextPage") && applicationList.getProperty("nextPage") != null ? applicationList.getProperty("nextPage").toString() : null;
                        cookie = applicationList.getCurrentPage().getItems().size() >= pageSize ? nextPage : null;
                    } else {
                        applicationList = (DefaultApplicationList)this.client.listApplications();
                    }
                }
                catch (Exception e) {
                    OktaUtils.wrapGeneralError("While getting Applications!", e);
                }
                if (applicationList != null) {
                    for (Application application : applicationList) {
                        handler.handle(this.fromApplication(application, attributesToGet));
                    }
                }
                if (handler instanceof SearchResultsHandler) {
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(cookie, remainingResults));
                }
            } else {
                Application result = null;
                try {
                    ApplicationList applications = this.client.listApplications(null, filter.toString(), null, null);
                    for (Application app : applications) {
                        if (handler.handle(this.fromApplication(app, attributesToGet))) continue;
                        LOG.ok("Stop processing of the result set", new Object[0]);
                        break;
                    }
                }
                catch (Exception e) {
                    OktaUtils.wrapGeneralError("While getting Application : " + filter.toString(), e);
                }
                if (result != null) {
                    handler.handle(this.fromApplication(result, attributesToGet));
                }
            }
        } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
            if (filter == null) {
                int remainingResults = -1;
                int pageSize = options.getPageSize() == null ? -1 : options.getPageSize();
                String cookie = options.getPagedResultsCookie();
                DefaultGroupList groupList = null;
                try {
                    if (pageSize != -1) {
                        String nextPage = StringUtil.isBlank((String)cookie) ? "/api/v1/groups?limit=" + pageSize : cookie;
                        groupList = (DefaultGroupList)this.client.getDataStore().getResource(nextPage, DefaultGroupList.class);
                        nextPage = groupList.hasProperty("nextPage") && groupList.getProperty("nextPage") != null ? groupList.getProperty("nextPage").toString() : null;
                        cookie = groupList.getCurrentPage().getItems().size() >= pageSize ? nextPage : null;
                    } else {
                        groupList = (DefaultGroupList)this.client.listGroups();
                    }
                }
                catch (Exception e) {
                    OktaUtils.wrapGeneralError("While getting Applications!", e);
                }
                if (groupList != null) {
                    for (Group group : groupList) {
                        handler.handle(this.fromGroup(group, attributesToGet));
                    }
                }
                if (handler instanceof SearchResultsHandler) {
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(cookie, remainingResults));
                }
            } else {
                try {
                    GroupList groups = "id".equals(filter.getAttribute()) || "name".equals(filter.getAttribute()) ? this.client.listGroups(filter.getValue(), null, null) : this.client.listGroups(null, filter.toString(), null);
                    for (Group group : groups) {
                        if (handler.handle(this.fromGroup(group, attributesToGet))) continue;
                        LOG.ok("Stop processing of the result set", new Object[0]);
                    }
                }
                catch (Exception e) {
                    OktaUtils.wrapGeneralError("While getting Groups: " + filter.toString(), e);
                }
            }
        } else {
            LOG.warn("Search of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
            throw new UnsupportedOperationException("Search of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    private long getLastLogEvent(ObjectClass objectClass) {
        LogEventList events;
        String filter = this.buildFilterByObjectClass(objectClass);
        if (StringUtil.isBlank((String)filter)) {
            OktaUtils.handleGeneralError("Provide envenType for Sync");
        }
        return (events = (LogEventList)this.client.getDataStore().getResource("/api/v1/logs?filter=" + filter + "&limit=1&sortOrder=DESCENDING", LogEventList.class)) != null && events.stream().count() > 0L ? ((LogEvent)events.single()).getPublished().getTime() : 0L;
    }

    private LogEventList getEvents(ObjectClass objectClass, Date since) {
        String filter = this.buildFilterByObjectClass(objectClass);
        if (StringUtil.isBlank((String)filter)) {
            LOG.info("Provide envenType for Sync {0}", new Object[]{objectClass});
            return null;
        }
        return this.client.getLogs(since, null, filter, null, "ASCENDING");
    }

    private String buildFilterByObjectClass(ObjectClass objectClass) {
        return ObjectClass.ACCOUNT.equals((Object)objectClass) ? this.buildLogEventFilter(this.configuration.getUserEvents()) : (ObjectClass.GROUP.equals((Object)objectClass) ? this.buildLogEventFilter(this.configuration.getGroupEvents()) : (APPLICATION.equals((Object)objectClass) ? this.buildLogEventFilter(this.configuration.getApplicationEvents()) : null));
    }

    private String buildLogEventFilter(String[] eventTypes) {
        boolean isFirst = true;
        StringBuilder builder = new StringBuilder();
        for (String type : eventTypes) {
            if (!isFirst) {
                builder.append(" or ");
            }
            builder.append("eventType eq ");
            builder.append("\"");
            builder.append(type);
            builder.append("\"");
            isFirst = false;
        }
        return builder.toString();
    }

    private ConnectorObject fromLogEvent(String id, long lastUpdate, ObjectClass objectClass) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(objectClass);
        builder.setUid(id);
        builder.setName(id);
        builder.addAttribute(new Attribute[]{OktaAttribute.buildAttribute(lastUpdate, "lastUpdated", Long.class).build()});
        return builder.build();
    }

    private ConnectorObject fromUser(User user, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.ACCOUNT);
        builder.setUid(user.getId());
        builder.setName(user.getId());
        return builder.addAttributes(OktaAttribute.buildUserAttributes(this.client, user, this.schema.getSchema(), attributesToGet)).build();
    }

    private ConnectorObject fromApplication(Application application, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(APPLICATION);
        builder.setUid(application.getId());
        builder.setName(application.getId());
        return builder.addAttributes(OktaAttribute.buildExtResourceAttributes(this.client, (ExtensibleResource)application, this.schema.getSchema(), attributesToGet, APPLICATION_NAME)).build();
    }

    private ConnectorObject fromGroup(Group group, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.GROUP);
        builder.setUid(group.getId());
        builder.setName(group.getId());
        return builder.addAttributes(OktaAttribute.buildExtResourceAttributes(this.client, (ExtensibleResource)group, this.schema.getSchema(), attributesToGet, ObjectClass.GROUP_NAME)).build();
    }

    private SyncDeltaBuilder buildSyncDelta(ConnectorObject connectorObject, LogEvent event) {
        long published;
        LOG.info("Build SyncDelta", new Object[0]);
        SyncDeltaBuilder bld = new SyncDeltaBuilder();
        if (this.isMembershipOperationEvent(event.getEventType())) {
            published = event.getPublished().getTime();
        } else {
            Attribute lastUpdate = connectorObject.getAttributeByName("lastUpdated");
            published = Long.valueOf(AttributeUtil.getSingleValue((Attribute)lastUpdate).toString());
        }
        bld.setToken(new SyncToken((Object)published));
        bld.setObject(connectorObject);
        bld.setDeltaType(this.getSyncDeltaTypeByEvent(event.getEventType()));
        LOG.ok("SyncDeltaBuilder is ok", new Object[0]);
        return bld;
    }

    private SyncDeltaType getSyncDeltaTypeByEvent(String event) {
        OktaEventType oktaEventType = OktaEventType.getValueByName(event);
        if (oktaEventType == null) {
            LOG.error("Okta event not found: {0}", new Object[]{event});
            OktaUtils.handleGeneralError("Okta event not defined");
        }
        return OktaEventType.getValueByName(event).getSyncDeltaType();
    }

    private boolean isDeleteEvent(String eventType) {
        return OktaEventType.getDeleteEventType().contains(eventType);
    }

    private boolean isMembershipOperationEvent(String eventType) {
        return OktaEventType.getMembershipOperationEventType().contains(eventType);
    }

    private void buildProfile(UserBuilder userBuilder, AttributesAccessor accessor, ObjectClass objectClass) {
        ObjectClassInfo objectClassInfo = this.schema.getSchema().findObjectClassInfo(objectClass.getObjectClassValue());
        accessor.listAttributeNames().stream().filter(attrName -> !NOT_FOR_PROFILE.contains(attrName)).forEach(attrName -> objectClassInfo.getAttributeInfo().stream().filter(attr -> attr.getName().equals(attrName)).findFirst().ifPresent(attributeInfo -> {
            if (OktaAttribute.BASIC_PROFILE_ATTRIBUTES.contains(attributeInfo.getName())) {
                switch (attributeInfo.getName()) {
                    case "firstName": {
                        userBuilder.setFirstName(AttributeUtil.getStringValue((Attribute)accessor.find(attrName)));
                        break;
                    }
                    case "lastName": {
                        userBuilder.setLastName(AttributeUtil.getStringValue((Attribute)accessor.find(attrName)));
                        break;
                    }
                    case "email": {
                        userBuilder.setEmail(AttributeUtil.getStringValue((Attribute)accessor.find(attrName)));
                        break;
                    }
                    case "login": {
                        userBuilder.setLogin(AttributeUtil.getStringValue((Attribute)accessor.find(attrName)));
                        break;
                    }
                    case "mobilePhone": {
                        userBuilder.setMobilePhone(AttributeUtil.getStringValue((Attribute)accessor.find(attrName)));
                        break;
                    }
                    case "secondEmail": {
                        userBuilder.setSecondEmail(AttributeUtil.getStringValue((Attribute)accessor.find(attrName)));
                        break;
                    }
                }
            } else if (Boolean.class.isInstance(attributeInfo.getType())) {
                userBuilder.putProfileProperty(attrName, (Object)AttributeUtil.getBooleanValue((Attribute)accessor.find(attrName)));
            } else if (Integer.class.isInstance(attributeInfo.getType())) {
                userBuilder.putProfileProperty(attrName, (Object)AttributeUtil.getIntegerValue((Attribute)accessor.find(attrName)));
            } else if (Long.class.isInstance(attributeInfo.getType())) {
                userBuilder.putProfileProperty(attrName, (Object)AttributeUtil.getLongValue((Attribute)accessor.find(attrName)));
            } else if (Float.class.isInstance(attributeInfo.getType())) {
                userBuilder.putProfileProperty(attrName, (Object)AttributeUtil.getFloatValue((Attribute)accessor.find(attrName)));
            } else if (Double.class.isInstance(attributeInfo.getType())) {
                userBuilder.putProfileProperty(attrName, (Object)AttributeUtil.getDoubleValue((Attribute)accessor.find(attrName)));
            } else if (Date.class.isInstance(attributeInfo.getType())) {
                userBuilder.putProfileProperty(attrName, (Object)AttributeUtil.getDateValue((Attribute)accessor.find(attrName)));
            } else if (Byte[].class.isInstance(attributeInfo.getType())) {
                userBuilder.putProfileProperty(attrName, (Object)AttributeUtil.getByteArrayValue((Attribute)accessor.find(attrName)));
            } else if (String.class.isInstance(attributeInfo.getType())) {
                userBuilder.putProfileProperty(attrName, (Object)AttributeUtil.getStringValue((Attribute)accessor.find(attrName)));
            } else {
                userBuilder.putProfileProperty(attrName, AttributeUtil.getSingleValue((Attribute)accessor.find(attrName)));
            }
        }));
    }

    private void updateUserAttributes(User user, Set<Attribute> replaceAttributes) {
        ObjectClassInfo objectClassInfo = this.schema.getSchema().findObjectClassInfo(ObjectClass.ACCOUNT_NAME);
        replaceAttributes.stream().filter(attribute -> !NOT_FOR_PROFILE.contains(attribute.getName())).forEach(attribute -> objectClassInfo.getAttributeInfo().stream().filter(attr -> attr.getName().equals(attribute.getName())).findFirst().ifPresent(attributeInfo -> {
            if (!CollectionUtil.isEmpty((Collection)attribute.getValue())) {
                if (OktaAttribute.BASIC_PROFILE_ATTRIBUTES.contains(attribute.getName())) {
                    switch (attributeInfo.getName()) {
                        case "firstName": {
                            user.getProfile().setFirstName(AttributeUtil.getStringValue((Attribute)attribute));
                            break;
                        }
                        case "lastName": {
                            user.getProfile().setLastName(AttributeUtil.getStringValue((Attribute)attribute));
                            break;
                        }
                        case "email": {
                            user.getProfile().setEmail(AttributeUtil.getStringValue((Attribute)attribute));
                            break;
                        }
                        case "login": {
                            user.getProfile().setLogin(AttributeUtil.getStringValue((Attribute)attribute));
                            break;
                        }
                        case "mobilePhone": {
                            user.getProfile().setMobilePhone(AttributeUtil.getStringValue((Attribute)attribute));
                            break;
                        }
                        case "secondEmail": {
                            user.getProfile().setSecondEmail(AttributeUtil.getStringValue((Attribute)attribute));
                            break;
                        }
                    }
                } else if (Boolean.class.isInstance(attributeInfo.getType())) {
                    user.getProfile().put((Object)attribute.getName(), (Object)AttributeUtil.getBooleanValue((Attribute)attribute));
                } else if (Integer.class.isInstance(attributeInfo.getType())) {
                    user.getProfile().put((Object)attribute.getName(), (Object)AttributeUtil.getIntegerValue((Attribute)attribute));
                } else if (String.class.isInstance(attributeInfo.getType())) {
                    user.getProfile().put((Object)attribute.getName(), (Object)AttributeUtil.getStringValue((Attribute)attribute));
                } else {
                    user.getProfile().put((Object)attribute.getName(), AttributeUtil.getSingleValue((Attribute)attribute));
                }
            }
        }));
    }

    private void updateUserStatus(User updatedUser, Attribute status) {
        if (status == null || CollectionUtil.isEmpty((Collection)status.getValue())) {
            LOG.warn("{0} attribute value not correct, can't handle User status update", new Object[]{OperationalAttributes.ENABLE_NAME});
        } else {
            boolean enabled = (Boolean)status.getValue().get(0);
            if (updatedUser.getStatus() == UserStatus.ACTIVE && !enabled) {
                updatedUser.suspend();
            } else if (updatedUser.getStatus() == UserStatus.SUSPENDED && enabled) {
                updatedUser.unsuspend();
            } else if (updatedUser.getStatus() == UserStatus.STAGED) {
                if (enabled) {
                    updatedUser.activate(Boolean.FALSE);
                } else {
                    LOG.ok("not suspending user {0} as in STAGED status", new Object[]{updatedUser.getId()});
                }
            } else if (updatedUser.getStatus() != UserStatus.DEPROVISIONED && !enabled) {
                updatedUser.deactivate();
            }
        }
    }

    private void selfPasswordUpdate(User user, GuardedString oldPassword, GuardedString newPassword) {
        try {
            user.changePassword(((ChangePasswordRequest)this.client.instantiate(ChangePasswordRequest.class)).setOldPassword(((PasswordCredential)this.client.instantiate(PasswordCredential.class)).setValue(SecurityUtil.decrypt((GuardedString)oldPassword).toCharArray())).setNewPassword(((PasswordCredential)this.client.instantiate(PasswordCredential.class)).setValue(SecurityUtil.decrypt((GuardedString)newPassword).toCharArray())));
            LOG.ok("Self change passsowrd user {0}" + user.getId(), new Object[0]);
        }
        catch (ResourceException e) {
            LOG.error((Throwable)e, e.getMessage(), new Object[0]);
            if (!CollectionUtil.isEmpty((Collection)e.getCauses())) {
                OktaUtils.handleGeneralError(((ErrorCause)e.getError().getCauses().get(0)).getSummary());
            } else {
                OktaUtils.handleGeneralError(e.getMessage(), (Exception)((Object)e));
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e, e.getMessage(), new Object[0]);
            OktaUtils.handleGeneralError(e.getMessage(), e);
        }
    }

    public void dispose() {
    }

    private static /* synthetic */ void lambda$create$0(UserBuilder userBuilder, String item) {
        userBuilder.addGroup(item);
    }
}

