/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.sun.mail.util.BASE64DecoderStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class EncodingUtil {
    public static final String EIGHT_BIT_ENCODING = "ISO-8859-1";
    public static final Charset CHARSET_EIGHT_BIT_ENCODING = StandardCharsets.ISO_8859_1;

    private EncodingUtil() {
    }

    public static InputStream toStream(String content, Charset charset) {
        byte[] bytes = content.getBytes(charset);
        return new ByteArrayInputStream(bytes);
    }

    public static String toString(InputStream is, Charset charset) {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = is.read(buffer)) != -1) {
                data.write(buffer, 0, length);
            }
            return data.toString(charset.name());
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not convert stream to string of charset " + charset, e);
        }
    }

    public static String decodeBase64(String encoded) {
        return new String(Base64.getDecoder().decode(encoded), StandardCharsets.UTF_8);
    }

    @Deprecated
    public static String readTillNullChar(BASE64DecoderStream stream) throws IOException {
        StringBuilder buf = new StringBuilder();
        int chr = stream.read();
        while (chr != 0 && chr > 0) {
            buf.append((char)chr);
            chr = stream.read();
        }
        return buf.toString();
    }
}

