/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.logger;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.syncope.client.cli.commands.CommonsResultManager;
import org.apache.syncope.client.cli.view.Table;
import org.apache.syncope.common.lib.log.LogStatement;
import org.apache.syncope.common.lib.log.LoggerTO;

public class LoggerResultManager
extends CommonsResultManager {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public void fromListMemoryAppenders(List<String> memoryAppenders) {
        Table.TableBuilder tableBuilder = new Table.TableBuilder("list memory appenders").header("appender");
        memoryAppenders.forEach(appender -> tableBuilder.rowValues(Collections.singletonList(appender)));
        tableBuilder.build().print();
    }

    public void fromGetLastLogStatements(List<LogStatement> statements) throws JsonProcessingException {
        Table.TableBuilder tableBuilder = new Table.TableBuilder("last statements").header("statement");
        for (LogStatement statement : statements) {
            tableBuilder.rowValues(Collections.singletonList(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)statement)));
        }
        tableBuilder.build().print();
    }

    public void fromList(List<LoggerTO> loggerTOs) {
        this.fromCommandToView("list loggers", "level", loggerTOs);
    }

    public void fromRead(List<LoggerTO> loggerTOs) {
        this.fromCommandToView("read loggers", "level", loggerTOs);
    }

    public void fromCreate(List<LoggerTO> loggerTOs) {
        this.fromCommandToView("created loggers", "level", loggerTOs);
    }

    public void fromUpdate(List<LoggerTO> loggerTOs) {
        this.fromCommandToView("updated loggers", "new level", loggerTOs);
    }

    public void fromDelete(List<LoggerTO> loggerTOs) {
        this.fromCommandToView("deleted loggers", "new level", loggerTOs);
    }

    private void fromCommandToView(String title, String secondHeader, List<LoggerTO> loggerTOs) {
        Table.TableBuilder tableBuilder = new Table.TableBuilder(title).header("logger").header(secondHeader);
        loggerTOs.forEach(loggerTO -> tableBuilder.rowValues(Arrays.asList(loggerTO.getKey(), loggerTO.getLevel().getLevel().name())));
        tableBuilder.build().print();
    }

    public void printDetails(Map<String, String> details) {
        this.printDetails("loggers details", details);
    }
}

