/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.configuration;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.configuration.ConfigurationDelete;
import org.apache.syncope.client.cli.commands.configuration.ConfigurationExport;
import org.apache.syncope.client.cli.commands.configuration.ConfigurationGet;
import org.apache.syncope.client.cli.commands.configuration.ConfigurationRead;
import org.apache.syncope.client.cli.commands.configuration.ConfigurationResultManager;
import org.apache.syncope.client.cli.commands.configuration.ConfigurationUpdate;

@Command(name="configuration")
public class ConfigurationCommand
extends AbstractCommand {
    private final ConfigurationResultManager configurationResultManager = new ConfigurationResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(Options.HELP.getOptionName());
        }
        switch (Options.fromName(input.getOption())) {
            case GET: {
                new ConfigurationGet(input).get();
                break;
            }
            case READ: {
                new ConfigurationRead(input).read();
                break;
            }
            case UPDATE: {
                new ConfigurationUpdate(input).update();
                break;
            }
            case DELETE: {
                new ConfigurationDelete(input).delete();
                break;
            }
            case EXPORT: {
                new ConfigurationExport(input).export();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.configurationResultManager.defaultOptionMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.configurationResultManager.commandHelpMessage(this.getClass());
    }

    private static enum Options {
        HELP("--help"),
        GET("--get"),
        READ("--read"),
        UPDATE("--update"),
        DELETE("--delete"),
        EXPORT("--export");

        private final String optionName;

        private Options(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static Options fromName(String name) {
            Options optionToReturn = HELP;
            for (Options option : Options.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (Options value : Options.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

