/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.core.spring.security;

import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.core.persistence.api.entity.Implementation;

public class TestImplementation implements Implementation {

    private static final long serialVersionUID = -2362660463135828190L;

    private String body;

    @Override
    public void setKey(final String key) {
        // nothing to do
    }

    @Override
    public String getKey() {
        return "";
    }

    @Override
    public ImplementationEngine getEngine() {
        return ImplementationEngine.JAVA;
    }

    @Override
    public void setEngine(ImplementationEngine engine) {
        // nothing to do
    }

    @Override
    public ImplementationType getType() {
        return ImplementationType.PASSWORD_RULE;
    }

    @Override
    public void setType(ImplementationType type) {
        // nothing to do
    }

    @Override
    public String getBody() {
        return body;
    }

    @Override
    public void setBody(final String body) {
        this.body = body;
    }

}
