/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.cxf.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.patch.MembershipPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.ext.scimv2.api.BadRequestException;
import org.apache.syncope.ext.scimv2.api.data.ListResponse;
import org.apache.syncope.ext.scimv2.api.data.SCIMGroup;
import org.apache.syncope.ext.scimv2.api.data.SCIMResource;
import org.apache.syncope.ext.scimv2.api.data.SCIMSearchRequest;
import org.apache.syncope.ext.scimv2.api.service.GroupService;
import org.apache.syncope.ext.scimv2.api.type.ErrorType;
import org.apache.syncope.ext.scimv2.api.type.Resource;
import org.apache.syncope.ext.scimv2.api.type.SortOrder;
import org.apache.syncope.ext.scimv2.cxf.service.AbstractService;

public class GroupServiceImpl
extends AbstractService<SCIMGroup>
implements GroupService {
    public Response create(SCIMGroup group) {
        ProvisioningResult result = this.groupLogic().create(this.binder().toGroupTO(group), false);
        group.getMembers().forEach(member -> {
            UserPatch patch = new UserPatch();
            patch.setKey(member.getValue());
            patch.getMemberships().add(((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.ADD_REPLACE)).group(((GroupTO)result.getEntity()).getKey()).build());
            try {
                this.userLogic().update(patch, false);
            }
            catch (Exception e) {
                LOG.error("While setting membership of {} to {}", new Object[]{((GroupTO)result.getEntity()).getKey(), member.getValue(), e});
            }
        });
        return this.createResponse(((GroupTO)result.getEntity()).getKey(), (SCIMResource)this.binder().toSCIMGroup((GroupTO)result.getEntity(), this.uriInfo.getAbsolutePathBuilder().path(((GroupTO)result.getEntity()).getKey()).build(new Object[0]).toASCIIString(), Collections.emptyList(), Collections.emptyList()));
    }

    public SCIMGroup get(String id, String attributes, String excludedAttributes) {
        return this.binder().toSCIMGroup(this.groupLogic().read(id), this.uriInfo.getAbsolutePathBuilder().build(new Object[0]).toASCIIString(), Arrays.asList(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)attributes, (char)','))), Arrays.asList(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)excludedAttributes, (char)','))));
    }

    public Response update(String id) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    public Response replace(String id, SCIMGroup group) {
        if (!id.equals(group.getId())) {
            throw new BadRequestException(ErrorType.invalidPath, "Expected " + id + ", found " + group.getId());
        }
        Response.ResponseBuilder builder = this.checkETag(Resource.Group, id);
        if (builder != null) {
            return builder.build();
        }
        HashSet beforeMembers = new HashSet();
        MembershipCond membCond = new MembershipCond();
        membCond.setGroup(id);
        SearchCond searchCond = SearchCond.getLeaf((AbstractSearchCond)membCond);
        int count = (Integer)this.userLogic().search(searchCond, 1, 1, Collections.emptyList(), "/", false).getLeft();
        for (int page = 1; page <= count / 500 + 1; ++page) {
            beforeMembers.addAll(((List)this.userLogic().search(searchCond, page, 500, Collections.emptyList(), "/", false).getRight()).stream().map(EntityTO::getKey).collect(Collectors.toSet()));
        }
        ProvisioningResult result = this.groupLogic().update(AnyOperations.diff((GroupTO)this.binder().toGroupTO(group), (GroupTO)this.groupLogic().read(id), (boolean)false), false);
        HashSet afterMembers = new HashSet();
        group.getMembers().forEach(member -> {
            afterMembers.add(member.getValue());
            if (!beforeMembers.contains(member.getValue())) {
                UserPatch patch = new UserPatch();
                patch.setKey(member.getValue());
                patch.getMemberships().add(((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.ADD_REPLACE)).group(((GroupTO)result.getEntity()).getKey()).build());
                try {
                    this.userLogic().update(patch, false);
                }
                catch (Exception e) {
                    LOG.error("While setting membership of {} to {}", new Object[]{((GroupTO)result.getEntity()).getKey(), member.getValue(), e});
                }
            }
        });
        beforeMembers.stream().filter(member -> !afterMembers.contains(member)).forEach(user -> {
            UserPatch patch = new UserPatch();
            patch.setKey(user);
            patch.getMemberships().add(((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.DELETE)).group(((GroupTO)result.getEntity()).getKey()).build());
            try {
                this.userLogic().update(patch, false);
            }
            catch (Exception e) {
                LOG.error("While removing membership of {} from {}", new Object[]{((GroupTO)result.getEntity()).getKey(), user, e});
            }
        });
        return this.updateResponse(((GroupTO)result.getEntity()).getKey(), (SCIMResource)this.binder().toSCIMGroup((GroupTO)result.getEntity(), this.uriInfo.getAbsolutePathBuilder().path(((GroupTO)result.getEntity()).getKey()).build(new Object[0]).toASCIIString(), Collections.emptyList(), Collections.emptyList()));
    }

    public Response delete(String id) {
        Response.ResponseBuilder builder = this.checkETag(Resource.Group, id);
        if (builder != null) {
            return builder.build();
        }
        this.anyLogic(Resource.Group).delete(id, false);
        return Response.noContent().build();
    }

    public ListResponse<SCIMGroup> search(String attributes, String excludedAttributes, String filter, String sortBy, SortOrder sortOrder, Integer startIndex, Integer count) {
        SCIMSearchRequest request = new SCIMSearchRequest(filter, sortBy, sortOrder, startIndex, count);
        if (attributes != null) {
            request.getAttributes().addAll(Arrays.asList(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)attributes, (char)','))));
        }
        if (excludedAttributes != null) {
            request.getExcludedAttributes().addAll(Arrays.asList(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)excludedAttributes, (char)','))));
        }
        return this.doSearch(Resource.Group, request);
    }

    public ListResponse<SCIMGroup> search(SCIMSearchRequest request) {
        return this.doSearch(Resource.Group, request);
    }
}

