/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;

public class AzureUtils {
    private static final Log LOG = Log.getLog(AzureUtils.class);
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public static Object extractCorrectValue(JsonNode node) {
        return StringUtil.isNotBlank((String)node.textValue()) ? node.textValue() : (node.asText().equals("false") || node.asText().equals("true") ? Boolean.valueOf(node.asBoolean()) : node.asText());
    }

    public static GuardedString createPassword(String password) {
        GuardedString guardedString = new GuardedString(password.toCharArray());
        return guardedString;
    }

    public static String getPasswordValue(GuardedString guardedString) {
        final StringBuilder clearPwd = new StringBuilder();
        GuardedString.Accessor accessor = new GuardedString.Accessor(){

            public void access(char[] clearChars) {
                clearPwd.append(clearChars);
            }
        };
        guardedString.access(accessor);
        return clearPwd.toString();
    }

    public static void handleGeneralError(String message) {
        LOG.error("General error : {0}", new Object[]{message});
        throw new ConnectorException(message);
    }

    public static void handleGeneralError(String message, Exception ex) {
        LOG.error((Throwable)ex, message, new Object[0]);
        throw new ConnectorException(message, (Throwable)ex);
    }

    public static void wrapGeneralError(String message, Exception ex) {
        LOG.error((Throwable)ex, message, new Object[0]);
        throw ConnectorException.wrap((Throwable)ex);
    }

    public static boolean checkAttribute(String attributeName, Map<String, List<Attribute>> attributes) {
        return attributes.containsKey(attributeName) && attributes.get(attributeName) != null && !attributes.get(attributeName).isEmpty();
    }
}

