/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.tirasa.connid.bundles.azure.dto.AzureError;
import net.tirasa.connid.bundles.azure.service.AzureRestAPI;
import net.tirasa.connid.bundles.azure.utils.AzureUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AzureService {
    private static final Log LOG = Log.getLog(AzureService.class);
    private static final String API_VERSION = "1.6";
    private static final String API_VERSION_PARAM = "api-version";
    private static final String ODATA_ERROR_ID = "odata.error";
    private static final String ODATA_NEXTPAGE_ID = "odata.nextLink";
    public static final String SKIP_TOKEN_ID = "$skiptoken=";
    public static final String METADATA_NAME_ID = "Name";
    public static final String METADATA_TYPE_ID = "Type";
    public static final String METADATA_NULLABLE_ID = "Nullable";
    public static final String METADATA_COLLECTION_VALUE = "Collection";
    public static final String USER_METADATA_TYPE_ID_VALUE = "User";
    public static final String GROUP_METADATA_TYPE_ID_VALUE = "Group";
    public static final String ACCEPT_HEADER = "Accept";
    private final String domain;
    private final String authority;
    private final String clientId;
    private final String username;
    private final String password;
    private final String resourceURI;
    private String pagedResultsSkipToken;
    private AuthenticationResult authenticationResult;
    private AzureRestAPI authenticated;

    public AzureService(String authority, String clientId, String username, String password, String resourceURI, String domain) {
        this.authority = authority;
        this.clientId = clientId;
        this.username = username;
        this.password = password;
        this.resourceURI = resourceURI;
        this.domain = domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAuth() {
        LOG.ok("Performing Azure account authentication", new Object[0]);
        ExecutorService service = null;
        try {
            service = Executors.newFixedThreadPool(1);
            AuthenticationContext context = new AuthenticationContext(this.authority, false, service);
            Future future = context.acquireToken(this.resourceURI, this.clientId, this.username, this.password, null);
            this.authenticationResult = (AuthenticationResult)future.get();
        }
        catch (InterruptedException | MalformedURLException | ExecutionException ex) {
            AzureUtils.handleGeneralError("While performing Azure authentication", ex);
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
    }

    private void checkAuth() {
        if (!this.isAuthenticated()) {
            this.doAuth();
        }
        this.checkTokenExpiry();
    }

    private boolean isAuthenticated() {
        return this.authenticationResult != null && StringUtil.isNotBlank((String)this.authenticationResult.getAccessToken());
    }

    private void checkTokenExpiry() {
        Date currentDate = new Date();
        Date expireOnDate = this.authenticationResult.getExpiresOnDate();
        if (currentDate.after(expireOnDate)) {
            LOG.info("Token expired! Refreshing...", new Object[0]);
            this.doAuth();
        }
    }

    public AzureRestAPI getAuthenticated() {
        this.checkAuth();
        if (this.authenticated == null) {
            this.authenticated = new AzureRestAPI(this);
        }
        return this.authenticated;
    }

    public WebClient getWebclient(String subDomain, String parameters) {
        this.checkAuth();
        WebClient webClient = WebClient.create((String)this.resourceURI).type("application/json").header("Authorization", new Object[]{"Bearer " + this.authenticationResult.getAccessToken()}).path((Object)this.domain).path((Object)subDomain).query(API_VERSION_PARAM, new Object[]{API_VERSION});
        if (StringUtil.isNotBlank((String)parameters)) {
            webClient.query(this.encodeURL(parameters), new Object[0]);
        }
        LOG.ok("webClient current URL : {0}", new Object[]{webClient.getCurrentURI()});
        return webClient;
    }

    public JsonNode doGetFromAzure(WebClient webClient) {
        JsonNode result = null;
        try {
            Response response = webClient.get();
            String responseAsString = (String)response.readEntity(String.class);
            result = AzureUtils.MAPPER.readTree(responseAsString);
            this.checkAzureErrors(result, response);
            JsonNode nextLink = result.get(ODATA_NEXTPAGE_ID);
            if (nextLink != null && !nextLink.isNull()) {
                this.pagedResultsSkipToken = StringUtils.substringAfter((String)nextLink.asText(), (String)SKIP_TOKEN_ID);
            }
            if (result.has("value") && !result.get("value").isNull()) {
                result = result.get("value");
            }
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While retrieving data from Azure AD service", new Object[0]);
        }
        return result;
    }

    public List<String> extractUsersFromGroupMemberships(JsonNode json) {
        ArrayList<String> userIds = new ArrayList<String>();
        if (json != null) {
            JsonNode urls;
            JsonNode jsonNode = urls = json.has("value") ? json.get("value") : json;
            if (urls != null && !urls.isNull() && urls.isArray()) {
                Iterator subAttrsNode = urls.elements();
                while (subAttrsNode.hasNext()) {
                    JsonNode entry = (JsonNode)subAttrsNode.next();
                    try {
                        String userId;
                        JsonNode obj;
                        String url = entry.get("url").asText();
                        WebClient webClient = this.getWebclient(url, null);
                        if (!url.contains(".Group") || (obj = this.doGetFromAzure(webClient)) == null || !StringUtil.isNotBlank((String)(userId = obj.get("objectId").asText()))) continue;
                        userIds.add(userId);
                    }
                    catch (Exception ex) {
                        LOG.error((Throwable)ex, "While parsing user groups!", new Object[0]);
                    }
                }
            }
        }
        return userIds;
    }

    private void checkAzureErrors(JsonNode node, Response response) {
        if (node.has(ODATA_ERROR_ID)) {
            AzureError.sendError("get object from Azure!", response);
        }
    }

    public static List<Map<String, String>> getMetadata(String type) {
        return AzureService.getXMLObjectFromAzureAD(type);
    }

    private static List<Map<String, String>> getXMLObjectFromAzureAD(String type) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        WebClient webClient = WebClient.create((String)"https://graph.windows.net").path((Object)"$metadata");
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(webClient.getCurrentURI().toString()).openConnection();
            connection.setRequestProperty(ACCEPT_HEADER, "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
            connection.setRequestProperty("Accept-Encoding", "gzip, deflate, br");
            connection.setRequestMethod("GET");
            InputStream xml = connection.getInputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(xml);
            doc.getDocumentElement().normalize();
            result.addAll(AzureService.getAttributesFromNodeList(doc, type));
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            AzureUtils.handleGeneralError("While getting xml metadata object", ex);
        }
        return result;
    }

    private static List<Map<String, String>> getAttributesFromNodeList(Document doc, String objType) {
        Node nNode;
        int i;
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        NodeList entityTypeList = doc.getElementsByTagName("EntityType");
        NodeList complexTypeList = doc.getElementsByTagName("ComplexType");
        for (i = 0; i < entityTypeList.getLength(); ++i) {
            nNode = entityTypeList.item(i);
            NodeList entitiesList = nNode.getChildNodes();
            Element eElement = (Element)((Object)entitiesList);
            String nodeName = eElement.getAttribute(METADATA_NAME_ID);
            if (!StringUtil.isNotBlank((String)nodeName) || !nodeName.equals(objType)) continue;
            for (int j = 0; j < entitiesList.getLength(); ++j) {
                Node subNode = entitiesList.item(j);
                if (!subNode.getNodeName().equals("Property")) continue;
                eElement = (Element)subNode;
                nodeName = eElement.getAttribute(METADATA_NAME_ID);
                String nodeType = eElement.getAttribute(METADATA_TYPE_ID);
                String nodeNullable = eElement.getAttribute(METADATA_NULLABLE_ID);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(METADATA_NAME_ID, nodeName);
                if (StringUtil.isNotBlank((String)nodeType)) {
                    map.put(METADATA_TYPE_ID, nodeType.replace("Edm.", ""));
                }
                if (StringUtil.isNotBlank((String)nodeNullable)) {
                    map.put(METADATA_NULLABLE_ID, nodeNullable);
                }
                list.add(map);
            }
        }
        for (i = 0; i < complexTypeList.getLength(); ++i) {
            nNode = complexTypeList.item(i);
            Element eElement = (Element)nNode;
            String nodeName = eElement.getAttribute(METADATA_NAME_ID);
            if (!StringUtil.isNotBlank((String)nodeName) || !nodeName.equals(objType)) continue;
            String nodeType = eElement.getAttribute(METADATA_TYPE_ID);
            String nodeNullable = eElement.getAttribute(METADATA_NULLABLE_ID);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(METADATA_NAME_ID, nodeName);
            if (StringUtil.isNotBlank((String)nodeType)) {
                map.put(METADATA_TYPE_ID, nodeType.replace("Edm.", ""));
            }
            if (StringUtil.isNotBlank((String)nodeNullable)) {
                map.put(METADATA_NULLABLE_ID, nodeNullable);
            }
            list.add(map);
        }
        return list;
    }

    private String encodeURL(String parameters) {
        return parameters.replace(" ", "%20");
    }

    public String getDomain() {
        return this.domain;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getResourceURI() {
        return this.resourceURI;
    }

    public String getPagedResultsSkipToken() {
        return this.pagedResultsSkipToken;
    }
}

