/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.ws.rs.core.Response;
import net.tirasa.connid.bundles.azure.service.NoSuchEntityException;
import net.tirasa.connid.bundles.azure.utils.AzureUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AzureError {
    @JsonProperty(value="odata.error")
    public ODataError odata_error;
    @JsonProperty(value="message")
    public Message message;

    public static String log(String action, Response response) {
        try {
            AzureError error = (AzureError)AzureUtils.MAPPER.readValue((String)response.readEntity(String.class), AzureError.class);
            ODataError oError = error.odata_error;
            return String.format("Failed to %s: status=%d code=%s reason=%s", action, response.getStatus(), oError == null ? "?" : oError.code, oError == null ? "?" : oError.message.value);
        }
        catch (Exception e) {
            String returnMessage = "Failed to " + action + "with response: " + (String)response.readEntity(String.class);
            return returnMessage.replaceAll("\\{", "'{'").replaceAll("\\}", "'}'");
        }
    }

    public static void sendError(String action, Response response) {
        String errorCode = null;
        try {
            AzureError error = (AzureError)AzureUtils.MAPPER.readValue((String)response.readEntity(String.class), AzureError.class);
            ODataError oError = error.odata_error;
            errorCode = oError.code;
        }
        catch (Exception e) {
            String returnMessage = "Failed to " + action + "with response: " + (String)response.readEntity(String.class);
            throw new RuntimeException(returnMessage.replaceAll("\\{", "'{'").replaceAll("\\}", "'}'"));
        }
        switch (errorCode) {
            case "Request_ResourceNotFound": {
                throw new NoSuchEntityException((String)response.readEntity(String.class));
            }
        }
        throw new RuntimeException((String)response.readEntity(String.class));
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ODataError {
        @JsonProperty(value="code")
        public String code;
        @JsonProperty(value="message")
        public Message message;
        @JsonProperty(value="values")
        public String values;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Message {
        @JsonProperty(value="lang")
        public String lang;
        @JsonProperty(value="value")
        public String value;
    }
}

