/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure;

import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;
import org.identityconnectors.framework.spi.StatefulConfiguration;

public class AzureConnectorConfiguration
extends AbstractConfiguration
implements StatefulConfiguration {
    private String clientId;
    private String authority;
    private String redirectURI;
    private String resourceURI;
    private String username;
    private String password;
    private String domain;
    public static final String DEFAULT_RESOURCE_URI = "https://graph.windows.net";
    public static final String DEFAULT_REDIRECT_URI = "https://login.live.com/oauth20_desktop.srf";

    @ConfigurationProperty(order=1, displayMessageKey="clientid.display", groupMessageKey="basic.group", helpMessageKey="clientid.help", required=true, confidential=false)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @ConfigurationProperty(order=2, displayMessageKey="authority.display", groupMessageKey="basic.group", helpMessageKey="authority.help", required=true, confidential=false)
    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    @ConfigurationProperty(order=3, displayMessageKey="redirectURI.display", groupMessageKey="basic.group", helpMessageKey="redirectURI.help", required=false, confidential=false)
    public String getRedirectURI() {
        return this.redirectURI;
    }

    public void setRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
    }

    @ConfigurationProperty(order=4, displayMessageKey="resourceURI.display", groupMessageKey="basic.group", helpMessageKey="resourceURI.help", required=false, confidential=false)
    public String getResourceURI() {
        return this.resourceURI;
    }

    public void setResourceURI(String resourceURI) {
        this.resourceURI = resourceURI;
    }

    @ConfigurationProperty(order=5, displayMessageKey="username.display", groupMessageKey="basic.group", helpMessageKey="username.help", required=true, confidential=false)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @ConfigurationProperty(order=6, displayMessageKey="password.display", groupMessageKey="basic.group", helpMessageKey="password.help", required=true, confidential=true)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ConfigurationProperty(order=7, displayMessageKey="domain.display", groupMessageKey="basic.group", helpMessageKey="domain.help", required=true, confidential=false)
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void validate() {
        if (StringUtil.isBlank((String)this.authority)) {
            throw new IllegalArgumentException("Authority cannot be null or empty.");
        }
        if (StringUtil.isBlank((String)this.clientId)) {
            throw new IllegalArgumentException("Client Id cannot be null or empty.");
        }
        if (StringUtil.isBlank((String)this.username)) {
            throw new IllegalArgumentException("Username cannot be null or empty.");
        }
        if (StringUtil.isBlank((String)this.password)) {
            throw new IllegalArgumentException("Password Id cannot be null or empty.");
        }
        if (StringUtil.isBlank((String)this.domain)) {
            throw new IllegalArgumentException("Domain Id cannot be null or empty.");
        }
        if (StringUtil.isBlank((String)this.redirectURI)) {
            this.redirectURI = DEFAULT_REDIRECT_URI;
        }
        if (StringUtil.isBlank((String)this.resourceURI)) {
            this.resourceURI = DEFAULT_RESOURCE_URI;
        }
    }

    public void release() {
    }
}

