/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.normalization;

import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.FilterVisitor;
import org.apache.directory.api.ldap.model.filter.LeafNode;
import org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.directory.api.ldap.model.filter.ObjectClassNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.filter.UndefinedNode;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.normalizers.ConcreteNameComponentNormalizer;
import org.apache.directory.api.ldap.model.schema.normalizers.NameComponentNormalizer;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursorImpl;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.normalization.FilterNormalizingVisitor;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizationInterceptor.class);
    private FilterNormalizingVisitor normVisitor;

    public NormalizationInterceptor() {
        super(InterceptorEnum.NORMALIZATION_INTERCEPTOR);
    }

    public void init(DirectoryService directoryService) throws LdapException {
        LOG.debug("Initialiazing the NormalizationInterceptor");
        super.init(directoryService);
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(this.schemaManager);
        this.normVisitor = new FilterNormalizingVisitor((NameComponentNormalizer)ncn, this.schemaManager);
    }

    public void destroy() {
    }

    public void add(AddOperationContext addContext) throws LdapException {
        Dn entryDn;
        Dn addDn = addContext.getDn();
        if (!addDn.isSchemaAware()) {
            addContext.setDn(new Dn(this.schemaManager, addDn));
        }
        if (!(entryDn = addContext.getEntry().getDn()).isSchemaAware()) {
            addContext.getEntry().setDn(new Dn(this.schemaManager, entryDn));
        }
        this.addRdnAttributesToEntry(addContext.getDn(), addContext.getEntry());
        this.next(addContext);
    }

    public boolean compare(CompareOperationContext compareContext) throws LdapException {
        Dn dn = compareContext.getDn();
        if (!dn.isSchemaAware()) {
            compareContext.setDn(new Dn(this.schemaManager, dn));
        }
        try {
            AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(compareContext.getOid());
            if (attributeType.getSyntax().isHumanReadable() && !compareContext.getValue().isHumanReadable()) {
                compareContext.setValue(compareContext.getValue());
            }
            compareContext.setAttributeType(attributeType);
        }
        catch (LdapException le) {
            throw new LdapInvalidAttributeTypeException(I18n.err((I18n)I18n.ERR_266, (Object[])new Object[]{compareContext.getOid()}));
        }
        return this.next(compareContext);
    }

    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        Dn dn = deleteContext.getDn();
        if (!dn.isSchemaAware()) {
            deleteContext.setDn(new Dn(this.schemaManager, dn));
        }
        this.next(deleteContext);
    }

    public boolean hasEntry(HasEntryOperationContext hasEntryContext) throws LdapException {
        Dn dn = hasEntryContext.getDn();
        if (!dn.isSchemaAware()) {
            hasEntryContext.setDn(new Dn(this.schemaManager, dn));
        }
        return this.next(hasEntryContext);
    }

    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        Dn dn = lookupContext.getDn();
        if (!dn.isSchemaAware()) {
            lookupContext.setDn(new Dn(this.schemaManager, dn));
        }
        return this.next(lookupContext);
    }

    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        Dn dn = modifyContext.getDn();
        if (!dn.isSchemaAware()) {
            modifyContext.setDn(new Dn(this.schemaManager, dn));
        }
        if (modifyContext.getModItems() != null) {
            for (Modification modification : modifyContext.getModItems()) {
                AttributeType attributeType = this.schemaManager.getAttributeType(modification.getAttribute().getId());
                modification.apply(attributeType);
            }
        }
        this.next(modifyContext);
    }

    public void move(MoveOperationContext moveContext) throws LdapException {
        Rdn rdn;
        Dn newDn;
        Dn newSuperiorDn;
        Dn oldSuperiorDn;
        Dn moveDn = moveContext.getDn();
        if (!moveDn.isSchemaAware()) {
            moveContext.setDn(new Dn(this.schemaManager, moveDn));
        }
        if (!(oldSuperiorDn = moveContext.getOldSuperior()).isSchemaAware()) {
            moveContext.setOldSuperior(new Dn(this.schemaManager, oldSuperiorDn));
        }
        if (!(newSuperiorDn = moveContext.getNewSuperior()).isSchemaAware()) {
            moveContext.setNewSuperior(new Dn(this.schemaManager, newSuperiorDn));
        }
        if (!(newDn = moveContext.getNewDn()).isSchemaAware()) {
            moveContext.setNewDn(new Dn(this.schemaManager, newDn));
        }
        if (!(rdn = moveContext.getRdn()).isSchemaAware()) {
            moveContext.setRdn(new Rdn(this.schemaManager, rdn));
        }
        this.next(moveContext);
    }

    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Dn newSuperiorDn;
        Dn newDn;
        Dn dn;
        Rdn newRdn = moveAndRenameContext.getNewRdn();
        if (!newRdn.isSchemaAware()) {
            moveAndRenameContext.setNewRdn(new Rdn(this.schemaManager, newRdn));
        }
        if (!(dn = moveAndRenameContext.getDn()).isSchemaAware()) {
            moveAndRenameContext.setDn(new Dn(this.schemaManager, dn));
        }
        if (!(newDn = moveAndRenameContext.getNewDn()).isSchemaAware()) {
            moveAndRenameContext.setNewDn(new Dn(this.schemaManager, newDn));
        }
        if (!(newSuperiorDn = moveAndRenameContext.getNewSuperiorDn()).isSchemaAware()) {
            moveAndRenameContext.setNewSuperiorDn(new Dn(this.schemaManager, newSuperiorDn));
        }
        this.next(moveAndRenameContext);
    }

    public void rename(RenameOperationContext renameContext) throws LdapException {
        Dn newDn;
        Rdn newRdn;
        Dn dn = renameContext.getDn();
        if (!dn.isSchemaAware()) {
            renameContext.setDn(new Dn(this.schemaManager, dn));
        }
        if (!(newRdn = renameContext.getNewRdn()).isSchemaAware()) {
            renameContext.setNewRdn(new Rdn(this.schemaManager, newRdn));
        }
        if (!(newDn = renameContext.getNewDn()).isSchemaAware()) {
            renameContext.setNewDn(new Dn(this.schemaManager, newDn));
        }
        this.next(renameContext);
    }

    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        ExprNode filter;
        Dn dn = searchContext.getDn();
        if (!dn.isSchemaAware()) {
            searchContext.setDn(new Dn(this.schemaManager, dn));
        }
        if ((filter = searchContext.getFilter()) == null) {
            LOG.warn("undefined filter based on undefined attributeType not evaluted at all.  Returning empty enumeration.");
            return new EntryFilteringCursorImpl((Cursor)new EmptyCursor(), searchContext, this.schemaManager);
        }
        if ((filter = (ExprNode)filter.accept((FilterVisitor)this.normVisitor)) == null) {
            LOG.warn("undefined filter based on undefined attributeType not evaluted at all.  Returning empty enumeration.");
            return new EntryFilteringCursorImpl((Cursor)new EmptyCursor(), searchContext, this.schemaManager);
        }
        ExprNode modifiedFilter = this.removeObjectClass(filter);
        searchContext.setFilter(modifiedFilter);
        return this.next(searchContext);
    }

    private ExprNode handleAndNode(ExprNode node) {
        int nbNodes = 0;
        AndNode newAndNode = new AndNode();
        for (ExprNode child : ((BranchNode)node).getChildren()) {
            ExprNode modifiedNode = this.removeObjectClass(child);
            if (!(modifiedNode instanceof ObjectClassNode)) {
                newAndNode.addNode(modifiedNode);
                ++nbNodes;
            }
            if (!(modifiedNode instanceof UndefinedNode)) continue;
            return UndefinedNode.UNDEFINED_NODE;
        }
        switch (nbNodes) {
            case 0: {
                return ObjectClassNode.OBJECT_CLASS_NODE;
            }
            case 1: {
                return newAndNode.getFirstChild();
            }
        }
        return newAndNode;
    }

    private ExprNode handleNotNode(ExprNode node) {
        for (ExprNode child : ((BranchNode)node).getChildren()) {
            ExprNode modifiedNode = this.removeObjectClass(child);
            if (modifiedNode instanceof ObjectClassNode) {
                return UndefinedNode.UNDEFINED_NODE;
            }
            if (!(modifiedNode instanceof UndefinedNode)) continue;
            return ObjectClassNode.OBJECT_CLASS_NODE;
        }
        return node;
    }

    private ExprNode handleOrNode(ExprNode node) {
        for (ExprNode child : ((BranchNode)node).getChildren()) {
            ExprNode modifiedNode = this.removeObjectClass(child);
            if (!(modifiedNode instanceof ObjectClassNode)) continue;
            return ObjectClassNode.OBJECT_CLASS_NODE;
        }
        return node;
    }

    private ExprNode removeObjectClass(ExprNode node) {
        LeafNode leafNode;
        if (node instanceof LeafNode && (leafNode = (LeafNode)node).getAttributeType() == this.directoryService.getAtProvider().getObjectClass()) {
            Value value;
            if (leafNode instanceof PresenceNode) {
                return ObjectClassNode.OBJECT_CLASS_NODE;
            }
            if (leafNode instanceof EqualityNode && (value = ((EqualityNode)leafNode).getValue()).equals((Object)"top")) {
                return ObjectClassNode.OBJECT_CLASS_NODE;
            }
        }
        if (node instanceof AndNode) {
            return this.handleAndNode(node);
        }
        if (node instanceof OrNode) {
            return this.handleOrNode(node);
        }
        if (node instanceof NotNode) {
            return this.handleNotNode(node);
        }
        return node;
    }

    private void addRdnAttributesToEntry(Dn dn, Entry entry) throws LdapException {
        if (dn == null || entry == null) {
            return;
        }
        Rdn rdn = dn.getRdn();
        for (Ava ava : rdn) {
            Value value = ava.getValue();
            String upValue = ava.getValue().getString();
            String upId = ava.getType();
            if (entry.contains(upId, new Value[]{value})) continue;
            String message = "The Rdn '" + upId + "=" + upValue + "' is not present in the entry";
            LOG.warn(message);
            if (!entry.containsAttribute(new String[]{upId})) {
                entry.add(upId, new String[]{upValue});
                continue;
            }
            AttributeType at = this.schemaManager.lookupAttributeTypeRegistry(upId);
            if (at.isSingleValued()) {
                entry.removeAttributes(new String[]{upId});
                entry.add(upId, new String[]{upValue});
                continue;
            }
            entry.add(upId, new String[]{upValue});
        }
    }
}

